/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLStructDataType;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SQLRowDataType
extends SQLObjectImpl
implements SQLDataType {
    private DbType dbType;
    private List<SQLStructDataType.Field> fields = new ArrayList<SQLStructDataType.Field>();

    public SQLRowDataType() {
    }

    public SQLRowDataType(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public String getName() {
        return "ROW";
    }

    @Override
    public long nameHashCode64() {
        return FnvHash.Constants.ROW;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SQLExpr> getArguments() {
        return Collections.emptyList();
    }

    @Override
    public Boolean getWithTimeZone() {
        return null;
    }

    @Override
    public void setWithTimeZone(Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWithLocalTimeZone() {
        return false;
    }

    @Override
    public void setWithLocalTimeZone(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.fields);
        }
        visitor.endVisit(this);
    }

    @Override
    public SQLRowDataType clone() {
        SQLRowDataType x = new SQLRowDataType(this.dbType);
        for (SQLStructDataType.Field field : this.fields) {
            x.addField(field.getName(), field.getDataType().clone());
        }
        return x;
    }

    public List<SQLStructDataType.Field> getFields() {
        return this.fields;
    }

    public SQLStructDataType.Field addField(SQLName name, SQLDataType dataType) {
        SQLStructDataType.Field field = new SQLStructDataType.Field(name, dataType);
        field.setParent(this);
        this.fields.add(field);
        return field;
    }

    @Override
    public int jdbcType() {
        return 2002;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isNumberic() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean hasKeyLength() {
        return false;
    }
}

