/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLObjectWithDataType;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDeclareItem
extends SQLObjectImpl
implements SQLObjectWithDataType,
SQLReplaceable {
    protected Type type;
    protected SQLName name;
    protected SQLDataType dataType;
    protected SQLExpr value;
    protected List<SQLTableElement> tableElementList = new ArrayList<SQLTableElement>();
    protected transient SQLObject resolvedObject;

    public SQLDeclareItem() {
    }

    public SQLDeclareItem(SQLName name, SQLDataType dataType) {
        this.setName(name);
        this.setDataType(dataType);
    }

    public SQLDeclareItem(SQLName name, SQLDataType dataType, SQLExpr value) {
        this.setName(name);
        this.setDataType(dataType);
        this.setValue(value);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.name == expr) {
            this.setName((SQLName)target);
            return true;
        }
        if (this.value == expr) {
            this.setValue(target);
            return true;
        }
        return false;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.name);
            this.acceptChild(visitor, this.dataType);
            this.acceptChild(visitor, this.value);
            this.acceptChild(visitor, this.tableElementList);
        }
        visitor.endVisit(this);
    }

    public SQLName getName() {
        return this.name;
    }

    public void setName(SQLName name) {
        if (name != null) {
            name.setParent(this);
        }
        this.name = name;
    }

    @Override
    public SQLDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(SQLDataType dataType) {
        if (dataType != null) {
            dataType.setParent(this);
        }
        this.dataType = dataType;
    }

    public SQLExpr getValue() {
        return this.value;
    }

    public void setValue(SQLExpr value) {
        if (value != null) {
            value.setParent(this);
        }
        this.value = value;
    }

    public List<SQLTableElement> getTableElementList() {
        return this.tableElementList;
    }

    public void setTableElementList(List<SQLTableElement> tableElementList) {
        this.tableElementList = tableElementList;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public SQLObject getResolvedObject() {
        return this.resolvedObject;
    }

    public void setResolvedObject(SQLObject resolvedObject) {
        this.resolvedObject = resolvedObject;
    }

    public static enum Type {
        TABLE,
        LOCAL,
        CURSOR;

    }
}

