/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter.providers;

import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastsql.interpreter.filters.FieldValueProvider;
import java.util.Map;

public class FastjsonFieldValueProvider
implements FieldValueProvider {
    private final SerializeConfig config;
    private final String fieldName;

    public FastjsonFieldValueProvider(String fieldName) {
        this.config = SerializeConfig.globalInstance;
        this.fieldName = fieldName;
    }

    public FastjsonFieldValueProvider(SerializeConfig config, String fieldName) {
        this.config = config;
        this.fieldName = fieldName;
    }

    @Override
    public Object getFieldValue(Object object) throws Exception {
        if (object instanceof Map) {
            return ((Map)object).get(this.fieldName);
        }
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        ObjectSerializer serializer = this.config.getObjectWriter(clazz);
        if (serializer instanceof JavaBeanSerializer) {
            return ((JavaBeanSerializer)serializer).getFieldValue(object, this.fieldName);
        }
        throw new UnsupportedOperationException();
    }
}

