/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter;

import com.alibaba.fastsql.interpreter.MapInterpreterContext;
import com.alibaba.fastsql.interpreter.expr.AddLong;
import com.alibaba.fastsql.interpreter.expr.ConstLong;
import com.alibaba.fastsql.interpreter.expr.DivideLong;
import com.alibaba.fastsql.interpreter.expr.EQLong;
import com.alibaba.fastsql.interpreter.expr.Expr;
import com.alibaba.fastsql.interpreter.expr.FieldLong;
import com.alibaba.fastsql.interpreter.expr.GELong;
import com.alibaba.fastsql.interpreter.expr.GTLong;
import com.alibaba.fastsql.interpreter.expr.IFLong;
import com.alibaba.fastsql.interpreter.expr.LELong;
import com.alibaba.fastsql.interpreter.expr.LTLong;
import com.alibaba.fastsql.interpreter.expr.LiteralNull;
import com.alibaba.fastsql.interpreter.expr.MaxLong;
import com.alibaba.fastsql.interpreter.expr.MinLong;
import com.alibaba.fastsql.interpreter.expr.MultipleLong;
import com.alibaba.fastsql.interpreter.expr.NELong;
import com.alibaba.fastsql.interpreter.expr.SubLong;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;
import java.util.Map;

public class TypeCalculation {
    public static Long calculateLiteralValue(String sql, Map<String, Long> inputs) {
        MapInterpreterContext context;
        SQLExpr sqlExpr = SQLUtils.toSQLExpr(sql);
        Expr<Long> expr = TypeCalculation.toExpr(sqlExpr, Long.class);
        Long result = expr.eval(context = new MapInterpreterContext(inputs));
        if (result == null) {
            return 0L;
        }
        return result;
    }

    private static <T> Expr<T> toExpr(SQLExpr x, Class<T> type) {
        if (x instanceof SQLMethodInvokeExpr) {
            return TypeCalculation.toFunctionCall((SQLMethodInvokeExpr)x, type);
        }
        if (x instanceof SQLIntegerExpr) {
            Number number = ((SQLIntegerExpr)x).getNumber();
            if (number instanceof Long) {
                return new ConstLong((Long)number);
            }
            if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
                return new ConstLong(number.longValue());
            }
        }
        if (x instanceof SQLBinaryOpExpr) {
            return TypeCalculation.toExpr((SQLBinaryOpExpr)x, type);
        }
        if (x instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr ident = (SQLIdentifierExpr)x;
            if (type == Long.class) {
                return new FieldLong(ident.normalizedName());
            }
        }
        if (x instanceof SQLNullExpr) {
            return LiteralNull.instance;
        }
        throw new UnsupportedOperationException(x.getClass().getName());
    }

    private static <T> Expr<T> toExpr(SQLBinaryOpExpr x, Class<T> type) {
        Expr<Long> left = TypeCalculation.toExpr(x.getLeft(), type);
        Expr<Long> right = TypeCalculation.toExpr(x.getRight(), type);
        switch (x.getOperator()) {
            case Add: {
                if (type != Long.class) break;
                return new AddLong(left, right);
            }
            case Subtract: {
                if (type != Long.class) break;
                return new SubLong(left, right);
            }
            case Multiply: {
                if (type != Long.class) break;
                return new MultipleLong(left, right);
            }
            case Divide: {
                if (type != Long.class) break;
                return new DivideLong(left, right);
            }
            case GreaterThan: {
                if (type != Long.class) break;
                return new GTLong(left, right);
            }
            case GreaterThanOrEqual: {
                if (type != Long.class) break;
                return new GELong(left, right);
            }
            case LessThan: {
                if (type != Long.class) break;
                return new LTLong(left, right);
            }
            case LessThanOrEqual: {
                if (type != Long.class) break;
                return new LELong(left, right);
            }
            case Equality: {
                if (type != Long.class) break;
                return new EQLong(left, right);
            }
            case LessThanOrGreater: 
            case NotEqual: {
                if (type != Long.class) break;
                return new NELong(left, right);
            }
            default: {
                throw new UnsupportedOperationException(x.getOperator().name);
            }
        }
        throw new UnsupportedOperationException(x.getClass().getName());
    }

    private static <T> Expr<T> toFunctionCall(SQLMethodInvokeExpr x, Class<T> type) {
        List<SQLExpr> arguments = x.getArguments();
        Expr[] exprList = new Expr[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            exprList[i] = TypeCalculation.toExpr(arguments.get(i), type);
        }
        long nameHashCode64 = x.methodNameHashCode64();
        if (nameHashCode64 == FnvHash.Constants.MIN) {
            return new MinLong((Expr<Long>[])exprList);
        }
        if (nameHashCode64 == FnvHash.Constants.MAX) {
            return new MaxLong((Expr<Long>[])exprList);
        }
        if (nameHashCode64 == FnvHash.Constants.IF && exprList.length == 3) {
            return new IFLong(exprList[0], exprList[1], exprList[2]);
        }
        throw new UnsupportedOperationException();
    }
}

