/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter;

import com.alibaba.fastsql.interpreter.Filter;
import com.alibaba.fastsql.interpreter.filters.AndFilter;
import com.alibaba.fastsql.interpreter.filters.BinaryOp;
import com.alibaba.fastsql.interpreter.filters.IntFilter;
import com.alibaba.fastsql.interpreter.filters.ListIntFilter;
import com.alibaba.fastsql.interpreter.filters.ListOp;
import com.alibaba.fastsql.interpreter.filters.ListStringFilter;
import com.alibaba.fastsql.interpreter.filters.OrFilter;
import com.alibaba.fastsql.interpreter.filters.StringFilter;
import com.alibaba.fastsql.interpreter.providers.FastjsonFieldValueProvider;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLParserUtils;
import com.alibaba.fastsql.sql.parser.Token;
import java.util.List;

public class Filters {
    public static Filter createFilter(String sql) {
        SQLExprParser parser = SQLParserUtils.createExprParser(sql, null, SQLParserFeature.EnableSQLBinaryOpExprGroup);
        SQLExpr expr = parser.expr();
        if (parser.getLexer().token() != Token.EOF) {
            throw new ParserException("illegal sql expr : " + sql, parser.getLexer().getPosLine(), parser.getLexer().getPosColumn());
        }
        return Filters.createFilter(expr);
    }

    private static Filter createFilter(SQLExpr expr) {
        if (expr instanceof SQLBinaryOpExpr) {
            Filter rightFilter;
            Filter leftFilter;
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)expr;
            SQLBinaryOperator op = binaryOpExpr.getOperator();
            SQLExpr left = binaryOpExpr.getLeft();
            SQLExpr right = binaryOpExpr.getRight();
            if (left instanceof SQLIdentifierExpr) {
                String property = ((SQLIdentifierExpr)left).getName();
                FastjsonFieldValueProvider fieldValueProvider = new FastjsonFieldValueProvider(property);
                if (right instanceof SQLIntegerExpr) {
                    Number number = ((SQLIntegerExpr)right).getNumber();
                    int val = (Integer)number;
                    switch (op) {
                        case Equality: {
                            return new IntFilter(val, BinaryOp.Eq, fieldValueProvider);
                        }
                        case NotEqual: 
                        case LessThanOrGreater: {
                            return new IntFilter(val, BinaryOp.Ne, fieldValueProvider);
                        }
                        case LessThan: {
                            return new IntFilter(val, BinaryOp.Lt, fieldValueProvider);
                        }
                        case LessThanOrEqual: {
                            return new IntFilter(val, BinaryOp.Le, fieldValueProvider);
                        }
                        case GreaterThan: {
                            return new IntFilter(val, BinaryOp.Gt, fieldValueProvider);
                        }
                        case GreaterThanOrEqual: {
                            return new IntFilter(val, BinaryOp.Ge, fieldValueProvider);
                        }
                    }
                } else if (right instanceof SQLCharExpr) {
                    String val = ((SQLCharExpr)right).getText();
                    switch (op) {
                        case Equality: {
                            return new StringFilter(val, BinaryOp.Eq, fieldValueProvider);
                        }
                        case NotEqual: 
                        case LessThanOrGreater: {
                            return new StringFilter(val, BinaryOp.Ne, fieldValueProvider);
                        }
                        case LessThan: {
                            return new StringFilter(val, BinaryOp.Lt, fieldValueProvider);
                        }
                        case LessThanOrEqual: {
                            return new StringFilter(val, BinaryOp.Le, fieldValueProvider);
                        }
                        case GreaterThan: {
                            return new StringFilter(val, BinaryOp.Gt, fieldValueProvider);
                        }
                        case GreaterThanOrEqual: {
                            return new StringFilter(val, BinaryOp.Ge, fieldValueProvider);
                        }
                    }
                }
            }
            if (op == SQLBinaryOperator.BooleanOr) {
                leftFilter = Filters.createFilter(left);
                rightFilter = Filters.createFilter(right);
                return new OrFilter(leftFilter, rightFilter);
            }
            if (op == SQLBinaryOperator.BooleanAnd) {
                leftFilter = Filters.createFilter(left);
                rightFilter = Filters.createFilter(right);
                return new AndFilter(leftFilter, rightFilter);
            }
        }
        if (expr instanceof SQLInListExpr) {
            SQLInListExpr inListExpr = (SQLInListExpr)expr;
            SQLExpr left = inListExpr.getExpr();
            List<SQLExpr> targetList = inListExpr.getTargetList();
            if (left instanceof SQLIdentifierExpr) {
                String property = ((SQLIdentifierExpr)left).getName();
                FastjsonFieldValueProvider fieldValueProvider = new FastjsonFieldValueProvider(property);
                Object[] values = new Object[targetList.size()];
                for (int i = 0; i < targetList.size(); ++i) {
                    Object value;
                    SQLObject item = targetList.get(i);
                    if (!(item instanceof SQLValuableExpr)) continue;
                    values[i] = value = ((SQLValuableExpr)item).getValue();
                }
                int intCount = 0;
                int strCount = 0;
                int longCount = 0;
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    if (value instanceof Integer) {
                        ++intCount;
                        continue;
                    }
                    if (value instanceof String) {
                        ++strCount;
                        continue;
                    }
                    if (!(value instanceof Long)) continue;
                    ++longCount;
                }
                if (intCount == values.length) {
                    int[] array = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        array[i] = (Integer)values[i];
                    }
                    if (inListExpr.isNot()) {
                        return new ListIntFilter(fieldValueProvider, ListOp.NOT_IN, array);
                    }
                    return new ListIntFilter(fieldValueProvider, ListOp.IN, array);
                }
                if (strCount == values.length) {
                    String[] array = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        array[i] = (String)values[i];
                    }
                    if (inListExpr.isNot()) {
                        return new ListStringFilter(fieldValueProvider, ListOp.NOT_IN, array);
                    }
                    return new ListStringFilter(fieldValueProvider, ListOp.IN, array);
                }
            }
        }
        throw new UnsupportedOperationException();
    }
}

