/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.funtions;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.funtions.DateFunctions;
import com.alibaba.fastsql.funtions.FunctionDef;
import com.alibaba.fastsql.funtions.MathFunctions;
import com.alibaba.fastsql.funtions.StringFunctions;
import com.alibaba.fastsql.sql.ast.SQLArrayDataType;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLMapDataType;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;

public class FunctionRepository {
    private final DbType dbType;
    private Map<Long, FunctionDef> functions = new LinkedHashMap<Long, FunctionDef>();
    public static final FunctionRepository MY_SQL = new FunctionRepository(DbType.mysql);

    public FunctionRepository(DbType dbType) {
        this.dbType = dbType;
    }

    private static SQLDataType[] dataType(Type[] types) {
        SQLDataType[] dataTypes = new SQLDataType[types.length];
        for (int i = 0; i < types.length; ++i) {
            dataTypes[i] = FunctionRepository.dataType(types[i]);
        }
        return dataTypes;
    }

    private static SQLDataType dataType(Type type) {
        ParameterizedType paramType;
        Type[] argTypes;
        if (String.class == type) {
            return SQLCharExpr.DATA_TYPE;
        }
        if (Integer.TYPE == type || Long.TYPE == type) {
            return SQLIntegerExpr.DATA_TYPE;
        }
        if (Double.TYPE == type) {
            return SQLNumberExpr.DATA_TYPE_DOUBLE;
        }
        if (java.util.Date.class == type || Date.class == type) {
            return SQLDateExpr.DATA_TYPE;
        }
        if (Timestamp.class == type) {
            return SQLTimestampExpr.DATA_TYPE;
        }
        if (Time.class == type) {
            return SQLTimeExpr.DATA_TYPE;
        }
        if (String[].class == type) {
            return SQLArrayDataType.ARRYA_CHAR;
        }
        if (byte[].class == type) {
            return new SQLDataTypeImpl("VARBINARY");
        }
        if (type instanceof ParameterizedType && (argTypes = (paramType = (ParameterizedType)type).getActualTypeArguments()).length == 2 && argTypes[0] == String.class && argTypes[1] == String.class) {
            return SQLMapDataType.MAP_CHAR_CHAR;
        }
        return null;
    }

    public void registerFunction(String name, SQLDataType returnType, SQLDataType ... parameterTypes) {
        this.registerFunction(name, false, returnType, parameterTypes);
    }

    public void registerFunction(String name, boolean varArg, SQLDataType returnType, SQLDataType ... parameterTypes) {
        FunctionDef func = new FunctionDef(name, varArg, returnType, parameterTypes);
        this.functions.put(func.nameHash64(), func);
    }

    public FunctionDef find(long hash) {
        return this.functions.get(hash);
    }

    public void registerFunction(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() == Object.class) continue;
            String name = method.getName();
            Type returnType = method.getGenericReturnType();
            Type[] paramTypes = method.getGenericParameterTypes();
            boolean isVarArgs = method.isVarArgs();
            if (isVarArgs) {
                Class<?> componentType;
                Type lastType = paramTypes[paramTypes.length - 1];
                paramTypes[paramTypes.length - 1] = componentType = ((Class)lastType).getComponentType();
            }
            this.registerFunction(name, isVarArgs, FunctionRepository.dataType(returnType), FunctionRepository.dataType(paramTypes));
        }
    }

    static {
        MY_SQL.registerFunction(StringFunctions.class);
        MY_SQL.registerFunction(DateFunctions.class);
        MY_SQL.registerFunction(MathFunctions.class);
    }
}

