/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql;

import com.alibaba.fastsql.util.FnvHash;

public enum DbType {
    other(0L),
    jtds(1L),
    hsql(2L),
    db2(3L),
    postgresql(4L),
    sqlserver(5L),
    oracle(6L),
    mysql(7L),
    mariadb(8L),
    derby(9L),
    hive(10L),
    h2(11L),
    dm(12L),
    kingbase(13L),
    gbase(14L),
    oceanbase(15L),
    informix(16L),
    odps(17L),
    teradata(18L),
    phoenix(19L),
    edb(20L),
    kylin(21L),
    sqlite(22L),
    ads(23L),
    presto(24L),
    elastic_search(25L),
    hbase(26L),
    drds(27L),
    clickhouse(28L),
    blink(29L),
    antspark(30L),
    greenplum(31L),
    adb_pg(32L),
    hologres(33L),
    impala(34L),
    explorer(35L),
    starrocks(36L),
    spark(37L);

    public final long mask;
    public final long hashCode64;

    private DbType(long mask) {
        this.mask = mask;
        this.hashCode64 = FnvHash.hashCode64(this.name());
    }

    public static long of(DbType ... types) {
        long value = 0L;
        for (DbType type : types) {
            value |= type.mask;
        }
        return value;
    }

    public static boolean derivedFromPg(DbType type) {
        return type == postgresql || type == adb_pg || type == hologres || type == greenplum;
    }
}

