import base64
import json

import requests
from packaging import version
from sseclient import SSEClient  # pip install sseclient-py

required_version = "2.32.3"

if version.parse(requests.__version__) < version.parse(required_version):
    raise RuntimeError(f"requests version must >= {required_version}")

with requests.post(
    "http://127.0.0.1:10000/process_alt",
    headers={
        "Authorization": "Bearer <EAS_TOKEN>",
    },
    files={
        "file": open("asset/test.wav", "rb"),
    },
    data={
        "metadata": json.dumps(
            {
                "format": "mp3",
                "sample_rate": 16000,
                "debug": True,
            }
        )
    },
    stream=True,
    timeout=30,
) as response:
    if response.status_code != 200:
        print(response.text)
        exit()

    messages = SSEClient(response)
    with open("./http_stream.mp3", "wb") as f:
        for i, msg in enumerate(messages.events()):
            # print(f"Event: {msg.event}, Data: {msg.data}")
            data = json.loads(msg.data)
            if data["error"] is not None:
                print(data["error"])
                break
            encode_buffer = data["output"]["audio"]["data"]
            decode_buffer = base64.b64decode(encode_buffer)
            f.write(decode_buffer)
            print(data["request_id"])
