# ALTDemo 使用说明

ALTDemo 是将 ASR、LLM、TTS 等三个环境串起来运行的 Demo，可以实现基本的机器人行为.
基于此 Demo，可以开发问答系统、客服系统等应用。

## 1. 安装依赖包

```bash
pip install -r requirements.txt
```

## 2. 创建 ASR 服务

参考文档：
https://pai.console.aliyun.com/?regionId=cn-hangzhou&workspaceId=133293#/quick-start/models/speech_paraformer-large_asr_nat-zh-cn-16k-common-vocab8404-pytorch/intro

## 3. 创建 LLM 服务

参考文档：
https://pai.console.aliyun.com/?regionId=cn-hangzhou&workspaceId=133293#/quick-start/models/Qwen3-14B-FP8/intro

## 4. 创建 TTS 服务

参考文档：
https://help.aliyun.com/zh/pai/use-cases/rapid-deployment-of-frontend-backend-separated-high-performance-services?spm=5176.pai-console-inland.console-base_help.dexternal.4eb32b6e1Utm0Z

## 5. 运行 WebUI 程序
```bash
python3 webui.py --ssl --port 7860
```

运行后，可通过浏览器访问：
https://x.x.x.x:7860/

## 6. 启动 API 服务并提供接口访问
```bash
uvicorn api_server:app --host 0.0.0.0 --port 10000
```

## 6.1 使用 curl 请求
```bash
curl -XPOST http://127.0.0.1:10000/process_alt \
--header 'Authorization: Bearer <EAS_TOKEN>' \
--form 'file=@"asset/test.wav"' \
--form "metadata={\"format\": \"mp3\", \"sample_rate\": 32000};type=application/json"
```

## 6.2 使用 Python requests.post() 请求
```bash
python3 http_stream.py #见本地的http_stream.mp3文件
```

