package com.aliyun.test;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.gateway.pop.Configuration;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.service.rdsai20250507.AsyncClient;
import com.aliyun.sdk.service.rdsai20250507.models.ChatMessagesRequest;
import com.aliyun.sdk.service.rdsai20250507.models.ChatMessagesResponseBody;
import darabonba.core.ResponseIterable;
import darabonba.core.ResponseIterator;
import darabonba.core.client.ClientOverrideConfiguration;
import org.apache.commons.lang3.StringUtils;

public class ChatMessagesSingleTurnDemo {
    public static void main(String[] args) {
        StaticCredentialProvider provider = StaticCredentialProvider.create(
                Credential.builder()
                        // 请确保已设置环境变量ALIBABA_CLOUD_ACCESS_KEY_ID和ALIBABA_CLOUD_ACCESS_KEY_SECRET。
                        .accessKeyId(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID"))
                        .accessKeySecret(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET"))
                        //.securityToken(System.getenv("ALIBABA_CLOUD_SECURITY_TOKEN")) // 使用STS token
                        .build());
        AsyncClient client = AsyncClient.builder()
                .region("cn-hangzhou")
                .credentialsProvider(provider)
                .serviceConfiguration(Configuration.create()
                        .setSignatureVersion(SignatureVersion.V3)
                ).overrideConfiguration(
                        ClientOverrideConfiguration.create()
                                .setProtocol("HTTPS")
                                // Endpoint 请参考 https://api.aliyun.com/product/RdsAi
                                .setEndpointOverride("rdsai.aliyuncs.com")
                ).build();

        //指定专属Agent对话则传入专属AgentID，专属AgentID在调用CreateCustomAgent接口成功后会返回，也可以通过接口ListCustomAgent获取当前创建的专属Agent列表中查询，详情查看ListCustomAgent接口文档
        //传入专属AgentID的Inputs: ChatMessagesRequest.Inputs.builder().timezone("Asia/Shanghai").regionId("cn-hangzhou").language("zh-CN").customAgentId("5f1bbe8a-88d8-4a72-81e5-2a5d9d43****").build();
        ChatMessagesRequest.Inputs inputs = ChatMessagesRequest.Inputs.builder()
                .timezone("Asia/Shanghai")
                .regionId("cn-hangzhou")
                .language("zh-CN")
                .build();

        // 多轮对话需要指定conversationId（会话ID），会话ID在调用ChatMessages接口成功后会返回，详情查看ChatMessages接口文档
        ChatMessagesRequest request = ChatMessagesRequest.builder()
                .inputs(inputs)
                .query("查询杭州地域实例列表")
                .build();
        try {
            ResponseIterable<ChatMessagesResponseBody> iterable = client.chatMessagesWithResponseIterable(request);
            ResponseIterator<ChatMessagesResponseBody> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                ChatMessagesResponseBody chunk = iterator.next();
                if (StringUtils.equals(chunk.getEvent(), "message")) {
                    System.out.print(chunk.getAnswer());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        // 关闭客户端
        client.close();
    }
}