# -*- coding: utf-8 -*-
import os
import sys
from typing import List

from alibabacloud_rdsai20250507.client import Client as RdsAi20250507Client
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_rdsai20250507 import models as rds_ai_20250507_models
from alibabacloud_tea_util import models as util_models

class ChatMessagesMultiTurnDemo:
    def __init__(self):
        pass

    @staticmethod
    def create_client() -> RdsAi20250507Client:

        # 请确保已设置环境变量ALIBABA_CLOUD_ACCESS_KEY_ID和ALIBABA_CLOUD_ACCESS_KEY_SECRET
        config = open_api_models.Config(
            access_key_id=os.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID"),
            access_key_secret=os.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET")
        )
        # Endpoint 请参考 https://api.aliyun.com/product/RdsAi
        config.endpoint = 'rdsai.aliyuncs.com'
        return RdsAi20250507Client(config)

    # 发送对话消息
    def do_chatMessages(self, search_query: str, conversation_id: str):
        runtime = util_models.RuntimeOptions(read_timeout=1000 * 100)
        # 指定专属Agent对话则传入专属AgentID，专属AgentID在调用CreateCustomAgent接口成功后会返回，也可以通过接口ListCustomAgent获取当前创建的专属Agent列表中查询，详情查看ListCustomAgent接口文档
        # inputs = rds_ai_models.ChatMessagesRequestInputs(language="zh-CN", region_id="cn-hangzhou", timezone="Asia/Shanghai",
        #                                                  custom_agent_id="5f1bbe8a-88d8-4a72-81e5-2a5d9d43****")
        inputs = rds_ai_20250507_models.ChatMessagesRequestInputs(
            language="zh-CN",
            region_id="cn-hangzhou",
            timezone="Asia/Shanghai"
        )
        # 多轮对话需要指定conversationId（会话ID），会话ID在调用ChatMessages接口成功后会返回，详情查看ChatMessages接口文档
        request = rds_ai_20250507_models.ChatMessagesRequest(
            query=search_query,
            inputs=inputs,
            conversation_id=conversation_id
        )
        sse_response = self.create_client().chat_messages_with_sse(tmp_req=request, runtime=runtime)
        return sse_response

    # 查看具体对话消息
    def do_getMessages(self, conversation_id: str):
        request = rds_ai_20250507_models.GetMessagesRequest(conversation_id=conversation_id)
        messages = self.create_client().get_messages(request)
        if messages and messages.body:
            return messages.body
        return None

    @staticmethod
    def main() -> None:
        chat_message = ChatMessagesMultiTurnDemo()
        conversation_id = None
        
        # 从初次对话中获取会话ID
        chat_messages_response = chat_message.do_chatMessages(search_query="查询杭州地域的实例列表", conversation_id=None)
        for chunk in chat_messages_response:
            body = chunk.body
            if body is not None and body.event == 'message':
                print(f"{body.answer}", end="")
                conversation_id = body.conversation_id

        assert conversation_id is not None

        # 发起二次对话，使用获取到的会话ID
        chat_messages_response = chat_message.do_chatMessages(search_query="查询第一个实例的详细信息", conversation_id=conversation_id)
        for chunk in chat_messages_response:
            body = chunk.body
            if body is not None and body.event == 'message':
                print(f"{body.answer}", end="")

        messages_body = chat_message.do_getMessages(conversation_id)
        print("\n" + str(messages_body))

if __name__ == '__main__':
    ChatMessagesMultiTurnDemo.main()
