//
//  FirstViewController.swift
//  ConvsationDemo
//
//  Created by 松果 on 2025/3/26.
//

import UIKit
import AVFoundation

class FirstViewController: UIViewController {
    
    init(endpointUrl: String){
        super.init(nibName: nil, bundle: nil)
    }
        
    // 创建4个标签
    lazy var label1: UILabel = createLabel(text: "服务链路:")
    lazy var label2: UILabel = createLabel(text: "workspaceId:")
    lazy var label3: UILabel = createLabel(text: "地址:")
    lazy var label4: UILabel = createLabel(text: "api_key:")
    lazy var label5: UILabel = createLabel(text: "appId:")
    lazy var label6: UILabel = createLabel(text: "vqa_img:")
    
    // 创建4个文本输入框
    lazy var textField1: UITextField = {
        let textField1 = createTextField(placeholder: "Websocket")
//        textField1.text = "wss://dashscope.aliyuncs.com/api-ws/v1/inference"
        return textField1
    }()
    lazy var textField2: UITextField = {
        let textField1 = createTextField(placeholder: "")
        textField1.text = ""
        return textField1
    }()
    lazy var textField3: UITextField = createTextField(placeholder: "wss://dashscope.aliyuncs.com/api-ws/v1/inference")
    lazy var textField4: UITextField = {
        let textField1 = createTextField(placeholder: "")
        textField1.text = ""
        return textField1
    }()
    lazy var textField5: UITextField = {
        let textField1 = createTextField(placeholder: "")
        textField1.text = ""
        return textField1
    }()
    lazy var textField6: UITextField = createTextField(placeholder: "https://help-static-aliyun-doc.aliyuncs.com/assets/img/zh-CN/7043267371/p909896.png")
    
    // 为每个标签和文本框创建水平堆叠视图
    lazy var row1: UIStackView = createRowStack(label: label1, textField: textField1)
    lazy var row2: UIStackView = createRowStack(label: label2, textField: textField2)
    lazy var row3: UIStackView = createRowStack(label: label3, textField: textField3)
    lazy var row4: UIStackView = createRowStack(label: label4, textField: textField4)
    lazy var row5: UIStackView = createRowStack(label: label5, textField: textField5)
    lazy var row6: UIStackView = createRowStack(label: label6, textField: textField6)
    
    // 创建一个垂直堆叠视图来容纳所有行
    lazy var formStackView: UIStackView = {
        let stack = UIStackView(arrangedSubviews: [row1, row2, row3, row4, row5, row6])
        stack.axis = .vertical
        stack.spacing = 20
        stack.distribution = .fillEqually
        stack.translatesAutoresizingMaskIntoConstraints = false
        return stack
    }()
    
    // 创建环境切换Toggle
    lazy var environmentToggleLabel: UILabel = {
        let label = UILabel()
        label.text = "使用RTC链路"
        label.font = UIFont.systemFont(ofSize: 16, weight: .medium)
        label.translatesAutoresizingMaskIntoConstraints = false
        return label
    }()
    
    lazy var environmentToggle: UISwitch = {
        let toggle = UISwitch()
        toggle.isOn = false // 默认为websocket
        toggle.addTarget(self, action: #selector(environmentToggleChanged), for: .valueChanged)
        toggle.translatesAutoresizingMaskIntoConstraints = false
        return toggle
    }()
    
    lazy var environmentStackView: UIStackView = {
        let stack = UIStackView(arrangedSubviews: [environmentToggleLabel, environmentToggle])
        stack.axis = .horizontal
        stack.spacing = 10
        stack.alignment = .center
        stack.distribution = .fill
        stack.translatesAutoresizingMaskIntoConstraints = false
        return stack
    }()
    
    lazy var startButton: UIButton = {
        let b = UIButton(type: .system)
        
        // 设置按钮标题和颜色
        b.setTitle("开始测试", for: .normal)
        b.setTitleColor(.white, for: .normal)
        b.titleLabel?.font = UIFont.boldSystemFont(ofSize: 18)
        
        // 设置按钮背景色
        b.backgroundColor = UIColor.blue
        
        // 设置按钮圆角
        b.layer.cornerRadius = 10
        b.clipsToBounds = true
        
        // 添加触摸事件
        b.addTarget(self, action: #selector(navigateToStoryboardVC), for: .touchUpInside)
        
        // 禁用自动翻译约束掩码
        b.translatesAutoresizingMaskIntoConstraints = false
        
        return b
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // 设置欢迎页面的UI元素
        view.backgroundColor = .white
        
        // 添加表单堆叠视图
        view.addSubview(formStackView)
        
        // 添加环境切换Toggle
        view.addSubview(environmentStackView)
        
        // 添加按钮
        view.addSubview(startButton)
        
        // 设置表单堆叠视图的约束
        NSLayoutConstraint.activate([
            formStackView.topAnchor.constraint(equalTo: view.safeAreaLayoutGuide.topAnchor, constant: 40),
            formStackView.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 20),
            formStackView.trailingAnchor.constraint(equalTo: view.trailingAnchor, constant: -20),
            formStackView.heightAnchor.constraint(equalToConstant: 240) // 6个行加间距
        ])
        
        // 设置环境切换Toggle的约束
        NSLayoutConstraint.activate([
            environmentStackView.topAnchor.constraint(equalTo: formStackView.bottomAnchor, constant: 20),
            environmentStackView.centerXAnchor.constraint(equalTo: view.centerXAnchor)
        ])
        
        // 设置按钮的约束
        NSLayoutConstraint.activate([
            // 水平居中
            startButton.centerXAnchor.constraint(equalTo: view.centerXAnchor),
            
            // 垂直位置 - 放在环境切换Toggle下方
            startButton.topAnchor.constraint(equalTo: environmentStackView.bottomAnchor, constant: 30),
            
            // 宽度
            startButton.widthAnchor.constraint(equalToConstant: 200),
            
            // 高度
            startButton.heightAnchor.constraint(equalToConstant: 50)
        ])
        
        // 设置键盘退出手势
        setupKeyboardDismiss()
    }
    
    // 创建标签的辅助方法
    private func createLabel(text: String) -> UILabel {
        let label = UILabel()
        label.text = text
        label.font = UIFont.systemFont(ofSize: 16, weight: .medium)
        label.textAlignment = .right
        label.setContentHuggingPriority(.defaultHigh, for: .horizontal)
        label.translatesAutoresizingMaskIntoConstraints = false
        return label
    }
    
    // 创建文本框的辅助方法
    private func createTextField(placeholder: String) -> UITextField {
        let textField = UITextField()
        textField.placeholder = placeholder
        textField.borderStyle = .roundedRect
        textField.clearButtonMode = .whileEditing
        textField.returnKeyType = .next
        textField.delegate = self
        textField.translatesAutoresizingMaskIntoConstraints = false
        return textField
    }
    
    // 创建行堆栈的辅助方法（标签+文本框）
    private func createRowStack(label: UILabel, textField: UITextField) -> UIStackView {
        let stack = UIStackView(arrangedSubviews: [label, textField])
        stack.axis = .horizontal
        stack.spacing = 10
        stack.alignment = .center
        stack.translatesAutoresizingMaskIntoConstraints = false
        
        // 设置标签宽度固定
        label.widthAnchor.constraint(equalToConstant: 100).isActive = true
        
        return stack
    }
    
    // 设置点击背景隐藏键盘
    private func setupKeyboardDismiss() {
        let tapGesture = UITapGestureRecognizer(target: self, action: #selector(dismissKeyboard))
        view.addGestureRecognizer(tapGesture)
    }
    
    @objc func dismissKeyboard() {
        view.endEditing(true)
    }
    
    @objc func environmentToggleChanged(_ sender: UISwitch) {
        if sender.isOn {
            //rtc
            textField1.text = "rtc"
            textField3.text = "https://dashscope.aliyuncs.com/api/v1/services/aigc/multimodal-generation/generation"
        } else {
            // websocket
            textField1.text = "websocket"
            textField3.text = "wss://dashscope.aliyuncs.com/api-ws/v1/inference"
        }
    }
    
    @objc func navigateToStoryboardVC() {
        if (!checkAndRequestPermissions()) {
            //无音视频权限
            print("premission error")
            return
        }
        let chatView = ChatViewController()

        let chainMode = getTextOrPlaceholder(from: textField1)
        let workSpaceId = getTextOrPlaceholder(from: textField2)
        let host = getTextOrPlaceholder(from: textField3)
        let apiKey = getTextOrPlaceholder(from: textField4)
        let appId = getTextOrPlaceholder(from: textField5)
        let img = getTextOrPlaceholder(from: textField6)
        
        
        
        chatView.updateParam(url: host, apiKey: apiKey, workSpaceId: workSpaceId, appId: appId, chain: chainMode, image_url: img)
        // 跳转到聊天页面
        print("==========>>>>>>>>> start dialog")
        self.present(chatView, animated: true)
    }
    
    // 获取文本框的文本或占位符的辅助方法
    private func getTextOrPlaceholder(from textField: UITextField) -> String {
        if let text = textField.text, !text.isEmpty {
            return text
        } else {
            return textField.placeholder ?? ""
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

// MARK: - UITextFieldDelegate
extension FirstViewController: UITextFieldDelegate {
    // 处理回车键
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        // 根据当前文本框，决定下一个响应者
        if textField == textField1 {
            textField2.becomeFirstResponder()
        } else if textField == textField2 {
            textField3.becomeFirstResponder()
        } else if textField == textField3 {
            textField4.becomeFirstResponder()
        } else if textField == textField4 {
            textField5.becomeFirstResponder()
        } else if textField == textField5 {
            textField6.becomeFirstResponder()
        } else {
            textField.resignFirstResponder() // 隐藏键盘
        }
        return true
    }
    
    
    // 检查摄像头权限状态
    func checkCameraPermission() -> AVAuthorizationStatus {
        return AVCaptureDevice.authorizationStatus(for: .video)
    }

    // 检查麦克风权限状态
    func checkMicrophonePermission() -> AVAuthorizationStatus {
        return AVCaptureDevice.authorizationStatus(for: .audio)
    }
    
    func requestCameraPermission(completion: @escaping (Bool) -> Void) {
        AVCaptureDevice.requestAccess(for: .video) { granted in
            DispatchQueue.main.async {
                completion(granted)
            }
        }
    }
    
    func requestMicrophonePermission(completion: @escaping (Bool) -> Void) {
        AVCaptureDevice.requestAccess(for: .audio) { granted in
            DispatchQueue.main.async {
                completion(granted)
            }
        }
    }
    
    func checkAndRequestPermissions() -> Bool {
        var hasCameraPremission = true
        var hasMicphonePremission = true
        // 检查摄像头权限
        let cameraStatus = checkCameraPermission()
        switch cameraStatus {
        case .authorized:
            print("摄像头已授权")
            hasCameraPremission = true
        case .denied, .restricted:
            print("摄像头权限被拒绝")
            hasCameraPremission = false
            showAlertToSettings()
        case .notDetermined:
            requestCameraPermission { granted in
                if granted {
                    print("摄像头权限已授予")
                    hasCameraPremission = true
                } else {
                    print("用户拒绝了摄像头权限")
                    hasCameraPremission = false
                }
            }
        @unknown default:
            break
        }

        // 检查麦克风权限
        let microphoneStatus = checkMicrophonePermission()
        switch microphoneStatus {
        case .authorized:
            print("麦克风已授权")
            hasMicphonePremission = true
        case .denied, .restricted:
            print("麦克风权限被拒绝")
            hasMicphonePremission = false
            showAlertToSettings()
        case .notDetermined:
            requestMicrophonePermission { granted in
                if granted {
                    print("麦克风权限已授予")
                    hasMicphonePremission = true
                } else {
                    print("用户拒绝了麦克风权限")
                    hasMicphonePremission = false
                }
            }
        @unknown default:
            break
        }
        
        return hasMicphonePremission && hasCameraPremission
    }

    // 跳转到系统设置
    func showAlertToSettings() {
        let alert = UIAlertController(
            title: "权限被拒绝",
            message: "请在设置中启用权限",
            preferredStyle: .alert
        )
        
        alert.addAction(UIAlertAction(title: "取消", style: .cancel))
        alert.addAction(UIAlertAction(title: "去设置", style: .default) { _ in
            if let url = URL(string: UIApplication.openSettingsURLString) {
                UIApplication.shared.open(url)
            }
        })
        
        // 确保在顶层视图控制器显示
        if let topVC = UIApplication.shared.windows.first?.rootViewController {
            topVC.present(alert, animated: true)
        }
    }
}

