class TingwuCache {
  length: number;
  data: Map<string, any>;
  constructor(length: number) {
    if (length < 1) {
      throw new Error("length不应 小于 1");
    }
    this.length = length;
    this.data = new Map();
  }
  set(key: string, value: any) {
    if (this.data.has(key)) {
      this.data.delete(key);
    }
    this.data.set(key, value);
    if (this.data.size > this.length) {
      const oldKey = this.data.keys().next().value;
      this.data.delete(oldKey);
    }
  }
  get(key: string) {
    if (!this.data.has(key)) return null;
    // 如果其存在,先删除,再添加(保证它是刚刚被访问过的)
    const val: any = this.data.get(key);
    this.data.delete(key);
    this.data.set(key, val);
    return val;
  }
}

export default TingwuCache;
