// Jest config for tingwu-util package
const path = require('path');

const rootConfig = require('../../jest.config.js');

module.exports = {
  ...rootConfig,
  rootDir: path.resolve(__dirname, '../..'),
  testMatch: ['<rootDir>/packages/tingwu-util/**/__tests__/**/*.test.{ts,tsx}'],
  setupFilesAfterEnv: ['<rootDir>/jest.setup.js'],
  transform: {
    '^.+\\.(ts|tsx)$': ['ts-jest', {
      tsconfig: {
        esModuleInterop: true,
        allowSyntheticDefaultImports: true,
        skipLibCheck: true,
      },
    }],
  },
  moduleNameMapper: {
    ...rootConfig.moduleNameMapper,
    // Map lodash-es to lodash (CommonJS) for testing
    '^lodash-es$': 'lodash',
    '^lodash-es/(.*)$': 'lodash/$1',
  },
};

