# @tingwu/util

听悟项目工具函数库，提供各种实用的工具函数。

## 📦 安装

```bash
npm install @tingwu/util
```

## 🎯 功能特性

- **图片处理**: 图片数据复制和处理
- **环境检测**: 环境变量检测
- **文本处理**: HTML 文本处理
- **键盘处理**: 键盘事件处理
- **节流器**: 段落变更和翻译节流器
- **句子处理**: 句子相关工具
- **缓存工具**: 缓存管理工具
- **通用工具**: 其他通用工具函数

## 📖 使用示例

```typescript
import { 
  paragraphChangeThrottler,
  unfixTranslateThrottler 
} from '@tingwu/util';
import { Controller, PID, Eventes, Paragraph } from '@tingwu/core';

// 段落变更节流器
const throttledParagraphChange = paragraphChangeThrottler(
  (controller: Controller, pid: PID, paragraph: Paragraph) => {
    // 处理段落变更
  },
  300
);

// 翻译节流器
const throttledTranslate = unfixTranslateThrottler(
  (controller: Controller, pid: PID) => {
    // 处理翻译
  },
  500
);
```

## 🔧 开发

```bash
# 安装依赖
npm install

# 构建
npm run build

# 运行测试
npm run test

# 代码检查
npm run lint
```

## 📄 许可证

[GPL-3.0-or-later](../../LICENSE)

