import { Speaker, AlibabaEmployee, UID, CommonUseSpeaker } from "@tingwu/core";

export const getSpeaker = (uid: UID, speakers: Speaker[]): Speaker | undefined => {
  const found = speakers.find(speaker => speaker.uid === uid);
  return found;
};

export const getDisplayAlibabaEmployeeName = (employee: AlibabaEmployee) => {
  return `${employee.name}${employee.nickName ? `(${employee.nickName})` : ""}`;
};

export const getSpeakerName = (
  speaker: Speaker | undefined,
  getDefaultName: (speaker?: Speaker) => string
) => {
  return (speaker && speaker.name) || getDefaultName(speaker);
};

export const UID_START_WORD = "c";

export const isInCommonSpeakers = (speaker: Speaker, currentUseSpeakersListData: Speaker[]) => {
  let canFind = false;
  for (let i = 0; i < currentUseSpeakersListData.length; i++) {
    if (
      speaker.bizUid == currentUseSpeakersListData[i].bizUid &&
      speaker.name === currentUseSpeakersListData[i].name
    ) {
      canFind = true;
    }
  }
  return canFind;
};

export const findDeleteCommonSpeakerIndex = (
  speaker: CommonUseSpeaker,
  currentUseSpeakersListData: CommonUseSpeaker[]
) => {
  let num = -1;
  for (let i = 0; i < currentUseSpeakersListData.length; i++) {
    if (
      speaker.bizUid == currentUseSpeakersListData[i].bizUid &&
      speaker.name === currentUseSpeakersListData[i].name
    ) {
      num = i;
    }
  }
  return num;
};
