export const getDirection = (
  top: number,
  bottom: number,
  scrollTop: number,
  scrollBottom: number
) => {
  const scrollHeight = Math.abs(scrollBottom - scrollTop);
  const scrollMiddleTop = scrollTop + scrollHeight / 2;
  if (top < scrollTop) {
    return "top";
  } else if (bottom > scrollBottom && top > scrollMiddleTop) {
    return "bottom";
  } else {
    return undefined;
  }
};
