export type ReportFunction = (evtId: string, data?: Record<string, any>) => void;

export type OnSendLog = (evtId: string, data?: Record<string, any>) => void;

let callback: ReportFunction = (evtId: string, data?: Record<string, any>) => {
  window.console.log(`[tingwu-transcription] report: evtId:${evtId}, data:`, data);
};

export const implementReport = (cb: ReportFunction) => {
  callback = cb;
};

export const report: ReportFunction = (evtId: string, data?: Record<string, any>) => {
  callback(evtId, data);
};
