import { Word, OldSelection, SID } from "@tingwu/core";
import { QAModelType } from "@tingwu/sphere";

export interface ViewedWord extends Word {
  searchedOffsets: Array<{
    startOffset: number;
    endOffset: number;
    isActive?: boolean;
  }>;
  isPlaying?: boolean;
  isPlayed?: boolean;
  isAgendaHighlight?: boolean;
  isTodoListHighlight?: boolean;
  isTranslate?: boolean;

  // 时间紧张，12.5-12.9周，暂时没时间拆分插件化，还先在这里实现 —— 津游
  isQna?: boolean;
  isQnaActive?: boolean;
  qnaModel?: QAModelType;
}

export const generateViewedWords = (
  words: Word[],
  foundSelections?: OldSelection[],
  activeSelection?: OldSelection,
  playingWord?: Word,
  isTranslate = false,
  agendaHightlightSids: SID[] = [],
  activeTodoListHighlightSids: SID[] = [],
  qnaSids: SID[] = [],
  activeQnaSids: SID[] = [],
  qnaModel?: QAModelType
): ViewedWord[] => {
  const sels = foundSelections?.slice() || [];
  let firstSel = sels.shift();
  let offset = 0;
  const extParams = {};

  return words.map(word => {
    const textLength = word.text.length;
    const nextOffset = textLength + offset;
    const viewedWord: ViewedWord = {
      ...word,
      ...extParams,
      searchedOffsets: [],
    };

    if (agendaHightlightSids.includes(word.sentenceId)) {
      viewedWord.isAgendaHighlight = true;
    }

    if (activeTodoListHighlightSids.includes(word.sentenceId)) {
      viewedWord.isTodoListHighlight = true;
    }

    // TODO QA data1
    if (qnaSids.includes(word.sentenceId)) {
      viewedWord.isQna = true;
    }

    if (qnaModel) {
      viewedWord.qnaModel = qnaModel;
    }

    if (activeQnaSids.includes(word.sentenceId)) {
      viewedWord.isQnaActive = true;
    }

    if (isTranslate) {
      viewedWord.isTranslate = true;
    }

    if (playingWord) {
      if (isTranslate) {
        if (word.sentenceId === playingWord.sentenceId) {
          viewedWord.isPlaying = true;
        }
        // 翻译模式，播放开始就认为是正在播放中
        if (Number(word.sentenceId) <= Number(playingWord.sentenceId)) {
          viewedWord.isPlayed = true;
        }
      } else {
        if (word.wid === playingWord.wid) {
          viewedWord.isPlaying = true;
        }
        if (word.endTime <= playingWord.endTime) {
          viewedWord.isPlayed = true;
        }
      }
    }

    while (true) {
      if (!firstSel) {
        break;
      }
      const { startOffset, endOffset } = firstSel;

      const isActiveSelection = firstSel === activeSelection;

      if (startOffset <= offset) {
        if (endOffset < nextOffset) {
          viewedWord.searchedOffsets.push({
            startOffset: 0,
            endOffset: endOffset - offset,
            isActive: isActiveSelection,
          });

          firstSel = sels.shift();
          continue;
        } else {
          viewedWord.searchedOffsets.push({
            startOffset: 0,
            endOffset: textLength,
            isActive: isActiveSelection,
          });
          if (endOffset === nextOffset) {
            firstSel = sels.shift();
          }
          break;
        }
      } else if (startOffset < nextOffset) {
        if (endOffset >= nextOffset) {
          viewedWord.searchedOffsets.push({
            startOffset: startOffset - offset,
            endOffset: textLength,
            isActive: isActiveSelection,
          });
          if (endOffset === nextOffset) {
            firstSel = sels.shift();
          }
          break;
        } else {
          viewedWord.searchedOffsets.push({
            startOffset: startOffset - offset,
            endOffset: endOffset - offset,
            isActive: isActiveSelection,
          });
          firstSel = sels.shift();
          continue;
        }
      } else {
        break;
      }
    }
    offset = nextOffset;

    return viewedWord;
  });
};
