import { Controller } from "@tingwu/core";
import { generateViewedWords } from "../viewedWord";

describe("generateViewedWords-4", () => {
  it("generateViewedWords-4", () => {
    const controller = new Controller();

    const tranModel = {
      pg: [
        {
          pi: "1656657111414500000",
          sc: [
            { bt: 7070, et: 7310, id: 40, si: 1, tc: "俩" },
            { bt: 7310, et: 7650, id: 50, si: 1, tc: "儿，" },
            { bt: 10220, et: 10860, id: 60, si: 1, tc: "紧一" },
            { bt: 11110, et: 11390, id: 70, si: 1, tc: "露" },
            { bt: 11390, et: 11540, id: 80, si: 1, tc: "下" },
            { bt: 11540, et: 11970, id: 90, si: 1, tc: "屏幕，" },
            { bt: 11970, et: 12480, id: 100, si: 1, tc: "震动" },
            { bt: 12480, et: 13050, id: 110, si: 1, tc: "一下fwjhh。" },
          ],
          ui: "1",
        },
      ],
    };

    controller.setModelValue(tranModel);
    const words = controller.getWords("1656657111414500000");

    const viewedWords = generateViewedWords(words, [
      {
        startOffset: 16,
        endOffset: 17,
        pid: "1656657111414500000",
      },
    ]);
    const target = [
      {
        beginTime: 7070,
        endTime: 7310,
        searchedOffsets: [],
        tag: "",
        text: "俩",
        wid: "40",
      },
      {
        beginTime: 7310,
        endTime: 7650,
        searchedOffsets: [],
        tag: "",
        text: "儿，",
        wid: "50",
      },
      {
        beginTime: 10220,
        endTime: 10860,
        searchedOffsets: [],
        tag: "",
        text: "紧一",
        wid: "60",
      },
      {
        beginTime: 11110,
        endTime: 11390,
        searchedOffsets: [],
        tag: "",
        text: "露",
        wid: "70",
      },
      {
        beginTime: 11390,
        endTime: 11540,
        searchedOffsets: [],
        tag: "",
        text: "下",
        wid: "80",
      },
      {
        beginTime: 11540,
        endTime: 11970,
        searchedOffsets: [],
        tag: "",
        text: "屏幕，",
        wid: "90",
      },
      {
        beginTime: 11970,
        endTime: 12480,
        searchedOffsets: [],
        tag: "",
        text: "震动",
        wid: "100",
      },
      {
        beginTime: 12480,
        endTime: 13050,
        searchedOffsets: [{ endOffset: 5, isActive: false, startOffset: 4 }],
        tag: "",
        text: "一下fwjhh。",
        wid: "110",
      },
    ];

    expect(viewedWords).toMatchObject(target);
  });
});
