import { useState } from "react";
import { useSyncEffect } from "@tingwu/common";
import { Controller, PID } from "@tingwu/core";

export const useRenderingParagraph = (controller: Controller, pid: PID) => {
  const [isFinishRender, setIsFinishRender] = useState(false);
  useSyncEffect(() => {
    return controller.on("renderingParagraph", ({ pid: _pid }) => {
      if (_pid === pid) {
        setIsFinishRender(false);
      }
    });
  }, [controller, pid]);

  useSyncEffect(() => {
    return controller.on("finishRenderParagraph", ({ pid: _pid }) => {
      if (_pid === pid) {
        setIsFinishRender(true);
      }
    });
  }, [controller, pid]);

  return { isFinishRender };
};
