import { TextPolishMode, TranslateMode } from "@tingwu/core";
import React from "react";
import { BaseExtension, RenderParagraphHeadingExtraParams } from "../baseExtension";
import { MarkHeadingExtra } from "./markHeadingExtra";

export class MarkExtension extends BaseExtension {
  renderParagraphHeadingExtra(params: RenderParagraphHeadingExtraParams) {
    /**
     * isUnfix 是否为unfix区域，unfix区域默认是显示，不受hover影响
     * isDropdownShowUp 当前MarkExtension中，划选状态和右上角的标记显示是互斥状态
     * isEditorFocus 是否是编辑状态，（fix区域）编辑状态和右上角的标记显示是互斥状态
     */
    const {
      isMouseEnter,
      controller,
      pid,
      emptyUnfix,
      isUnfix,
      isDropdownShowUp,
      // isEditorFocus,
      readonly,
      translateMode,
      textPolishMode,
      shareDisabled,
    } = params;

    // 只显示译文时，不显示此内容
    if (
      translateMode === TranslateMode.TranslateOnly ||
      textPolishMode === TextPolishMode.TextPolishOnly
    ) {
      return;
    }

    // 只读状态下，右上角打标
    if (readonly) {
      return;
    }

    // 如果处于编辑状态，fix区域右上角打标是不会出现的，unfix区域不受影响
    // if (isEditorFocus && !isUnfix) {
    //   return;
    // }

    // mouseEnter 是否是hover状态，fix hover时候右上角出现标记，unfix区域常驻，所以unfix这个值始终为true;
    const mouseEnter = isUnfix ? true : isMouseEnter;

    // isDropdownShowUp 为true, 表示划选会下拉选择菜单这个时候右上角的标记消失，否则根据mouseEnter决定
    const isVisible = isDropdownShowUp ? false : mouseEnter;

    return (
      <MarkHeadingExtra
        visible={isVisible}
        controller={controller}
        pid={pid}
        emptyUnfix={emptyUnfix}
        shareDisabled={shareDisabled}
      />
    );
  }

  getIsRenderUnfixSpeakerPlaceholder() {
    return false;
  }
}
