import { TYIcon } from "@tingwu/design";
import React, { memo } from "react";
import { Container, Button, IconWrapper } from "./styled";

export const ChromeScrollToBottomForNotSticky: React.FC<{
  onClick?: () => void;
}> = memo(props => {
  const { onClick } = props;

  return (
    <Container>
      <Button onClick={onClick}>
        <IconWrapper>
          <TYIcon type={"tongyi-down-line"} style={{ fontSize: 16 }} />
        </IconWrapper>
        回到最新内容
      </Button>
    </Container>
  );
});
