import { TYIcon } from "@tingwu/design";
import React, { memo } from "react";
import { Wrapper, Background, ReturnButton } from "./styled";

export const ChromeScrollToBottom: React.FC<{
  onClick?: () => void;
}> = memo(props => {
  const { onClick, ...restProps } = props;

  return (
    <Wrapper {...restProps}>
      <Background>
        <ReturnButton onClick={onClick}>
          <TYIcon type={"tongyi-top-line"} style={{ fontSize: 20 }} />
        </ReturnButton>
      </Background>
    </Wrapper>
  );
});
