import { TranslateMode } from "@tingwu/core";
import React from "react";
import {
  BaseExtension,
  RenderParagraphHeadingExtraParams,
  RenderSelectionContextMenuParams,
  RenderScrollToBottomButtonParams,
} from "../baseExtension";
import { ChromeContextMenu } from "./chromeContextMenu";
import { ChromeHeadingExtra } from "./chromeHeadingExtra";
import { ChromeScrollToBottomForNotSticky } from "./chromeScrollToBottomForNotSticky";

export class ChromeExtension extends BaseExtension {
  renderParagraphHeadingExtra(params: RenderParagraphHeadingExtraParams) {
    /**
     * isUnfix 是否为unfix区域，unfix区域默认是显示，不受hover影响
     * isDropdownShowUp 当前ChromeExtension中，划选状态和右上角的标记显示是互斥状态
     * isEditorFocus 是否是编辑状态，（fix区域）编辑状态和右上角的标记显示是互斥状态
     */
    const {
      isMouseEnter,
      controller,
      pid,
      emptyUnfix,
      isUnfix,
      isDropdownShowUp,
      isEditorFocus,
      readonly,
      translateMode,
    } = params;

    // 只显示译文时，不显示此内容
    if (translateMode === TranslateMode.TranslateOnly) {
      return;
    }

    // 只读状态下，右上角打标
    if (readonly) {
      return;
    }

    // 如果处于编辑状态，fix区域右上角打标是不会出现的，unfix区域不受影响
    if (isEditorFocus && !isUnfix) {
      return;
    }

    // mouseEnter 是否是hover状态，fix hover时候右上角出现标记，unfix区域常驻，所以unfix这个值始终为true;
    const mouseEnter = isUnfix ? true : isMouseEnter;

    // isDropdownShowUp 为true, 表示划选会下拉选择菜单这个时候右上角的标记消失，否则根据mouseEnter决定
    const isVisible = isDropdownShowUp ? false : mouseEnter;

    return (
      <ChromeHeadingExtra
        visible={isVisible}
        controller={controller}
        pid={pid}
        emptyUnfix={emptyUnfix}
      />
    );
  }

  renderUnfixMask() {
    return <div />;
  }

  renderSelectionContextMenu(params: RenderSelectionContextMenuParams) {
    const { controller, currentSelection } = params;
    return <ChromeContextMenu controller={controller} currentSelection={currentSelection} />;
  }

  getContextMenuSize() {
    return {
      width: 148,
      height: 40,
    };
  }

  getIsRenderUnfixSpeakerPlaceholder() {
    return false;
  }

  renderScrollToBottomButton(params: RenderScrollToBottomButtonParams) {
    const { onScrollToBottom, isShowingLivingScrollToBottom } = params;

    if (!isShowingLivingScrollToBottom) {
      return null;
    }

    return <ChromeScrollToBottomForNotSticky onClick={onScrollToBottom} />;
  }

  getIsShowTranslatePopup() {
    return false;
  }
}
