import { Controller, PID, Selection, TextPolishMode, TranslateMode } from "@tingwu/core";
import React from "react";

export interface Size {
  width: number;
  height: number;
}

export interface BasicRenderParagraphHeadingExtraParams {
  pid?: PID;
  emptyUnfix?: boolean;
  isMouseEnter: boolean;
  isUnfix?: boolean;
  isDropdownShowUp?: boolean;
  isEditorFocus: boolean;
  readonly?: boolean;
  translateMode: TranslateMode;
  textPolishMode?: TextPolishMode;
  shareDisabled?: boolean;
}
export interface RenderParagraphHeadingExtraParams extends BasicRenderParagraphHeadingExtraParams {
  controller: Controller;
}

export interface RenderUnfixMaskParams {
  onClick?: () => void;
}

export interface RenderSelectionContextMenuParams {
  controller: Controller;
  currentSelection: Selection;
}

export interface GetParagraphTopHeightParams {
  controller: Controller;
  pid: PID;
  width: number;
}

export interface RenderScrollToBottomButtonParams {
  controller: Controller;
  isShowingLivingScrollToBottom: boolean;
  onScrollToBottom?: () => void;
}

export abstract class BaseExtension {
  init?(params: { controller: Controller }): void;

  renderParagraphHeadingExtra?(
    params: RenderParagraphHeadingExtraParams
  ): React.ReactNode | undefined;
  renderUnfixMask?(params: RenderUnfixMaskParams): React.ReactNode;
  renderSelectionContextMenu?(
    params: RenderSelectionContextMenuParams
  ): React.ReactNode | undefined;
  getIsRenderUnfixSpeakerPlaceholder?(): boolean;
  getContextMenuSize?(): Size;

  isHasParagraphBottom?(): boolean;
  getParagraphBottomHeight?(): number;
  getParagraphBottom?(): React.ReactNode;

  isHasParagraphTop?(params: GetParagraphTopHeightParams): boolean;
  getParagraphTopHeight?(params: GetParagraphTopHeightParams): number;
  renderParagraphTop?(params: GetParagraphTopHeightParams): React.ReactNode;

  providerParagraphsNeedRefresh?(needRefresh: () => void): (() => void) | undefined;

  renderScrollToBottomButton?(params: RenderScrollToBottomButtonParams): React.ReactNode;

  getIsShowTranslatePopup?(): boolean;
}
