import styled from "styled-components";

export const DROPDOWN_WIDTH = 128;
export const DROPDOWN_HEIGHT = 148;
export const DROPDOWN_ONE_ITEM_HEIGHT = 52;
export const DROPDOWN_PADDING = 10;

export const Dropdown = styled.div`
  position: absolute;

  /*
   zindex of unfix paragraph is 200,
   when dropdown created by fix paragraph, the zindex is 100
   when dropdown created by unfix paragraph, the zindex is 300
   */
  z-index: 100; /* 100 or 300 */
  top: -9999px;
  left: -9999px;
  user-select: none;
  width: 128px;
`;

export const Menu = styled.div`
  border-radius: 8px;
  padding: 4px 0;
  background: #fff;
  box-shadow:
    0 3px 6px -4px rgba(39, 38, 77, 0.12),
    0 6px 16px 0 rgba(39, 38, 77, 0.08),
    0 9px 28px 8px rgba(39, 38, 77, 0.05);
`;

export const MenuItem = styled.div`
  height: 44px;
  display: flex;
  align-items: center;
  font-size: 14px;
  color: #27264d;
  line-height: 24px;
  padding: 0 16px;
  cursor: pointer;

  &:hover {
    background: var(--Fill_Background);
  }
`;

export const MenuItemIcon = styled.div`
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-right: 12px;
`;

export const MenuItemText = styled.div`
  white-space: nowrap;
  color: var(--Text_Primary);
`;

export const MenuColorWrapper = styled.div`
  flex: 1 1;
  display: flex;
  justify-content: flex-end;
  align-items: center;
`;

export const MenuColorTag = styled.div<{
  color: "blue" | "red" | "yellow";
  active?: boolean;
}>`
  width: 16px;
  height: 16px;
  border-radius: 16px;
  cursor: pointer;
  margin-right: 12px;
  display: flex;
  justify-content: center;
  align-items: center;
  position: relative;

  &:after {
    position: absolute;
    content: " ";
    top: 0;
    left: 0;
    width: 16px;
    height: 16px;
    border-radius: 16px;
    z-index: 1;
    transition: all 0.2s;
    transform-origin: center center;
  }

  &:hover:after {
    transform: scale(125%);
  }

  svg {
    display: none;
    position: relative;
    z-index: 2;
  }

  ${props =>
    props.color === "blue" &&
    `
    &:after {
      background-color: #9AE4FF;
    }
  `}

  ${props =>
    props.color === "yellow" &&
    `
    &:after {
      background-color: #F9FA6F;
    }
  `}
  ${props =>
    props.color === "red" &&
    `
    &:after {
      background-color: #F8BAD7;
    }
  `}

  ${props =>
    props.active &&
    `
    &:after {
      transform: scale(125%);
    }
    svg {
      display: block;
    }
  `}
`;

export const MenuCloseTagWraper = styled.div`
  width: 16px;
  height: 16px;
  cursor: pointer;
  &:hover {
    svg {
      transition: all 0.2s;
      transform-origin: center center;
      transform: scale(125%);
    }
  }
`;
