import styled, { css } from "styled-components";

export const Wrapper = styled.div<{
  livingMode?: boolean;
  isHasUnfix?: boolean;
  showPaddingTop?: boolean;
}>`
  padding-left: ${props => props.theme.transHorizontalPadding}px;
  padding-right: ${props => props.theme.transHorizontalPadding}px;
  min-height: 100%;
  padding-top: ${props => (props.showPaddingTop ? `${props.theme.transVerticalPadding}px` : "0px")};

  ${props =>
    (!props.livingMode || !props.isHasUnfix) &&
    css`
      padding-bottom: ${props.theme.transPaddingBottom}px;
    `}
`;

export const FixParagraphList = styled.div`
  position: relative;
`;

export const ParagraphContentBox = styled.div`
  position: absolute;
  left: 0;
  right: 0;
`;
