import styled from "styled-components";

export const Wrapper = styled.div`
  position: relative;
  display: flex;
  overflow: hidden;
  min-width: ${props => props.theme.transMinWidth}px;
`;

export const ScrollContainer = styled.div`
  /* overflow: auto;
  overflow: overlay; */
  overflow-x: hidden;
  overscroll-behavior: contain;
  position: relative;
  /* 如果padding-bottom:0则会导致最下边的元素阴影会有截断 */
  padding-bottom: 10px;
  flex: 1 1;
`;

export const ToTopButton = styled.div<{
  bottom: number;
}>`
  position: absolute;
  background-color: var(--Fill_Background_Light);
  right: 31px;
  bottom: ${props => props.bottom}px;
  cursor: pointer;
  box-shadow: 0 4px 6px 0 rgba(0, 0, 0, 0.08);
  border-radius: 6px;
  font-size: 20px;
  line-height: 22px;
  color: var(--Text_Secondary);
  height: 32px;
  width: 32px;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 301;
  border: 1px solid var(--Line_Secondary);
`;

export const ScrollContainerInner = styled.div`
  min-height: 100%;
`;

export const AutoScrollButton = styled.div<{
  bottom: number;
}>`
  position: absolute;
  background-color: var(--Fill_Background_Light);
  right: 31px;
  bottom: ${props => props.bottom}px;
  cursor: pointer;
  box-shadow: 0 4px 6px 0 rgba(0, 0, 0, 0.08);
  border-radius: 6px;
  font-size: 20px;
  line-height: 22px;
  color: var(--Text_Secondary);
  height: 32px;
  width: 32px;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 301;
  border: 1px solid var(--Line_Secondary);
`;

export const TranscriptionContentWrapper = styled.div``;

// export const DoubleArrowDownPng = styled.div`
//   width: 20px;
//   height: 20px;
//   background-image: url('data:image/png;base64,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');
//   background-position: 0 0;
//   background-repeat: no-repeat;
//   background-size: contain;
// `;
