import styled, { css } from "styled-components";
import { WordsStyled } from "../../wordsStyled";
import { config } from "../../../config";
import { AssistantActiveType } from "@tingwu/sphere";

const { paragraph } = config.theme;

export const ParagraphTranslate = styled(WordsStyled)<{
  showOrigin?: boolean;
  isHighlight?: boolean;
  isUnfix?: boolean;
  aiReviewActive?: AssistantActiveType | null;
}>`
  width: 100%;
  position: relative;
  font-size: 14px;
  font-family: ${props => props.theme.editorFontFamily};
  line-height: 24px;
  padding: ${props => props.theme.paragraphVerticalPadding}px
    ${props => props.theme.paragraphHorizontalPadding}px;
  background-color: ${paragraph.backgroundColor};
  color: var(--Text_Caption);
  border-bottom-left-radius: 8px;
  border-bottom-right-radius: 8px;
  caret-color: transparent;
  outline: none;
  cursor: text;
  user-select: text;
  border-top: 1px dashed var(--Line_Secondary);

  ${props => {
    if (!props?.showOrigin && props.aiReviewActive === AssistantActiveType.originActive) {
      return `background-color: #E7E7FB;
      border: 1px solid #605CE5;
      `;
    }
    return "";
  }}

  span::selection {
    background-color: var(--Line_Primary);
    color: ${props => (props.isHighlight ? "var(--Text_Brand_Primary)" : "var(--Text_Caption)")};
  }

  ${props =>
    props.isUnfix &&
    css`
      min-height: 96px;
      user-select: none;
      cursor: default;
    `}

  ${props =>
    props.showOrigin &&
    css`
      padding-top: 8px;
    `}

  ${props =>
    !props.showOrigin &&
    css`
      border-top-left-radius: 8px;
      border-top-right-radius: 8px;
    `}

  ${props =>
    props.isHighlight &&
    css`
      background-color: var(--Fill_Brand_Background);
      color: var(--Text_Primary);
    `}

  &:before {
    content: " ";
    display: ${props => (props.showOrigin && !props.isHighlight ? "block" : "none")};
    background-color: var(--Fill_Transparent_Light);
    height: 1px;
    position: absolute;
    top: 0;
    left: ${props => props.theme.paragraphHorizontalPadding}px;
    right: ${props => props.theme.paragraphHorizontalPadding}px;
  }
`;

export const FixText = styled.span<{
  isHighlight?: boolean;
}>`
  color: ${props => (props.isHighlight ? "var(--Text_Brand_Primary)" : "var(--Text_Secondary)")};
`;

export const UnfixText = styled.span`
  color: rgba(255, 255, 255, 0.6);
`;

export const TextPolishTagHide = styled.div`
  margin-top: 10px;
  height: 10px;
`;

export const TextPolishTag = styled.div<{
  isHighlight?: boolean;
}>`
  margin-top: 10px;
  font-size: 10px;
  font-weight: normal;
  line-height: 10px;
  text-align: justify;
  letter-spacing: 0;
  color: ${props => (props.isHighlight ? "rgba(255, 255, 255, 0.8)" : "var(--Text_Primary)")};
  display: flex;
  align-items: center;
  position: absolute;
  bottom: 16px;
  left: 24px;
  user-select: none;
  width: calc(100% - 48px);
  img {
    width: 10px;
    height: 10px;
    margin-right: 7px;
  }
`;
