import React, { memo } from "react";
import { PID } from "@tingwu/core";
import {
  Wrapper,
  Title,
  Content,
  WrapFlex,
  SplitLine,
  // NailButton,
  // QuestionButton,
  // TodoButton,
  // ResetButton,
} from "./styled";
import { TagControlBarUseHover } from "./tagControlBarUseHover";
import { Tooltip } from "@tingwu/design";
import { Icon } from "./iconbar";

/**
 * onClickNail 可选 重点
 * onClickQuestion 可选  问题
 * onClickTodo 可选 代办
 * onClickReset 可选  重置/清空
 * title 可选 显示标题
 * useHover 可选 默认不支持  是否支持hover：放大1.2倍
 * markButtonMarginLeft 可选 默认值8 按钮之间间距
 */

export interface TagControlBarProps {
  onClickNail?: (event: React.MouseEvent) => void;
  onClickQuestion?: (event: React.MouseEvent) => void;
  onClickTodo?: (event: React.MouseEvent) => void;
  onClickReset?: (event: React.MouseEvent) => void;
  onClickShare?: (event: React.MouseEvent) => void;
  title?: string;
  useHover?: boolean;
  tagControlBarSpaceBetween?: number;
  pid?: PID;
  isShareFeature?: boolean; // 是否需要局部分享
  shareDisabled?: boolean; // 局部分享禁止
}

export const TagControlBar: React.FC<TagControlBarProps> = memo(props => {
  const {
    onClickNail,
    onClickQuestion,
    onClickTodo,
    onClickReset,
    onClickShare,
    title,
    tagControlBarSpaceBetween = 8,
    useHover,
    pid,
    isShareFeature,
    shareDisabled,
  } = props;

  const tagControlBars = React.useMemo(() => {
    const data: Array<{
      bar: React.ReactElement;
      key: string;
      tips?: string;
      isSplitLine?: boolean;
    }> = [
      {
        bar: (
          <Tooltip title="标记为重点">
            <Icon
              type={"icon-extractMark-line"}
              size={16}
              color={"var(--Caution_Default )"}
              key={`${title}Nail`}
              onMouseDown={onClickNail}
            />
            {/* <NailButton
              key={`${title}Nail`}
              onMouseDown={onClickNail}
            /> */}
          </Tooltip>
        ),
        key: `${title}Nail`,
      },
      {
        bar: (
          <Tooltip title="标记为问题">
            <Icon
              type={"icon-help-line"}
              size={17}
              color={"var(--Warning_Default)"}
              key={`${title}Question`}
              onMouseDown={onClickQuestion}
            />
            {/* <QuestionButton
              key={`${title}Question`}
              style={{ marginLeft: tagControlBarSpaceBetween }}
              onMouseDown={onClickQuestion}
            /> */}
          </Tooltip>
        ),
        key: `${title}Question`,
      },
      {
        bar: (
          <Tooltip title="标记为待办">
            <Icon
              type={"tongyi-todoList-line"}
              size={16}
              color={"var(--Processing_Default)"}
              onMouseDown={onClickTodo}
            />
            {/* <TodoButton
              key={`${title}Todo`}
              style={{ marginLeft: tagControlBarSpaceBetween }}
              onMouseDown={onClickTodo}
            /> */}
          </Tooltip>
        ),
        key: `${title}Todo`,
        tips: "标记为待办",
      },
      {
        bar: (
          <Tooltip title="取消标记">
            <Icon
              type={"icon-delete01-line"}
              size={16}
              color={"var(--Success_Default)"}
              key={`${title}Reset`}
              onMouseDown={onClickReset}
              data-e2e-test-id="trans_paragraphHead_tagReset_button"
            />
            {/* <ResetButton
              key={`${title}Reset`}
              style={{ marginLeft: tagControlBarSpaceBetween }}
              onMouseDown={onClickReset}
              data-e2e-test-id="trans_paragraphHead_tagReset_button"
            /> */}
          </Tooltip>
        ),
        key: `${title}Reset`,
      },
    ];

    if (isShareFeature) {
      data.push({
        bar: (
          <Tooltip title={shareDisabled ? "抱歉，当前记录暂不支持分享" : "分享记录"}>
            <Icon
              type={"tingwu-fenxiang1"}
              size={16}
              color={shareDisabled ? "#e7e7f8" : "#8885ec"}
              key={`${title}Share`}
              onMouseDown={shareDisabled ? undefined : onClickShare}
              style={{ cursor: shareDisabled ? "not-allowed" : "pointer" }}
            />
          </Tooltip>
        ),
        key: `${title}Share`,
        isSplitLine: true,
      });
    }
    return data;
  }, [pid, isShareFeature]);

  return (
    <Wrapper>
      {title ? <Title>{title}</Title> : null}
      <Content
        gap={tagControlBarSpaceBetween}
        style={{ gridTemplateColumns: isShareFeature ? "repeat(4, 1fr) auto" : "repeat(4, 1fr)" }}
      >
        {tagControlBars.map(tagControlBarInfo => {
          const dom = useHover ? (
            <TagControlBarUseHover
              key={`hover${tagControlBarInfo.key}`}
              tagControlBar={tagControlBarInfo.bar}
            />
          ) : (
            tagControlBarInfo.bar
          );

          return (
            <>
              {tagControlBarInfo?.isSplitLine ? (
                <WrapFlex>
                  <SplitLine type="vertical" />
                  {dom}
                </WrapFlex>
              ) : (
                dom
              )}
            </>
          );
        })}
      </Content>
    </Wrapper>
  );
});
