import { Divider } from "antd";
import styled, { keyframes } from "styled-components";

export const Wrapper = styled.div`
  display: flex;
  align-items: center;
  z-index: 1; /* 解决 unfix hover会被遮挡问题 */
`;

export const Title = styled.div`
  font-size: 12px;
  color: rgba(39, 38, 77, 0.65);
  line-height: 20px;
  white-space: nowrap;
  cursor: default;
`;

export const Content = styled.div<{
  gap: number;
}>`
  grid-template-columns: repeat(4, 1fr) auto;
  display: grid;
  gap: ${props => props.gap || 8}px;
  align-items: center;

  & .tingwu-icon {
    position: relative;

    &:after {
      content: "";
      display: block;
      top: -5px;
      left: -5px;
      right: -5px;
      bottom: -5px;
    }
  }
`;

const BaseButton = styled.div`
  width: 16px;
  height: 16px;
  cursor: pointer;
`;

export const NailButton = styled(BaseButton)`
  background: url("https://img.alicdn.com/imgextra/i2/O1CN014J4tmL1IydoI9zCMb_!!6000000000962-2-tps-200-200.png")
    0 0 no-repeat;
  background-size: contain;
  width: 16px;
  height: 16px;
`;

export const QuestionButton = styled(BaseButton)`
  background: url("https://img.alicdn.com/imgextra/i3/O1CN01kn6xGP27kwMhrpPqo_!!6000000007836-2-tps-200-200.png")
    0 0 no-repeat;
  background-size: contain;
  width: 16px;
  height: 16px;
`;

export const TodoButton = styled(BaseButton)`
  background: url("https://img.alicdn.com/imgextra/i4/O1CN01DO5d6820cyA2dZeQp_!!6000000006871-2-tps-200-200.png")
    0 0 no-repeat;
  background-size: contain;
  width: 16px;
  height: 16px;
`;

export const ResetButton = styled(BaseButton)`
  background: url("https://img.alicdn.com/imgextra/i2/O1CN01p3JzB01h8IwbBRomW_!!6000000004232-2-tps-200-200.png")
    0 0 no-repeat;
  width: 16px;
  height: 16px;
  background-size: contain;
`;

export const TagControlBarUseHoverContainer = styled.div`
  display: flex;
  cursor: pointer;
  &:hover {
    transform: scale(1.2);
  }
`;

export const WrapFlex = styled.div`
  display: flex;
  align-items: center;
  padding-right: 8px;
`;

export const SplitLine = styled(Divider)`
  margin-left: 4px;
  margin-right: 12px;
  height: 13px;
`;

export const IconBarContent = styled.div<{ color: string; rotate?: number }>`
  width: 100%;
  height: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  border-radius: 100%;
  background-color: ${({ color }) => color};
  transform: ${({ rotate }) => `rotate(${rotate}deg)`};
  font-size: 12px;
  color: white;
`;
const loadingCircle = keyframes`
  100% {
    transform: rotate(360deg);
  }
`;
export const IconContainer = styled.span<{ size?: number }>`
  display: inline-flex;
  width: ${({ size }) => (size ? `${size}px` : "16px")};
  height: ${({ size }) => (size ? `${size}px` : "16px")};

  .tingwu-icon-spin {
    animation: ${loadingCircle} 1s infinite linear;
  }
`;
