import React, { memo } from "react";
import { IconContainer, IconBarContent } from "./styled";
import { loadIcon } from "./iconfont";
import { TYIcon } from "@tingwu/design";

interface IconProps extends Omit<React.HTMLProps<HTMLSpanElement>, "ref" | "as"> {
  type: string;
  viewBox?: string;
  size?: number;
  color: string;
  spin?: boolean;
  rotate?: number;
}

export const Icon = memo((props: IconProps) => {
  const { type, viewBox, size, color, spin, rotate = 0, className = "", ...rest } = props;

  React.useEffect(() => {
    loadIcon();
  }, []);

  return (
    <IconContainer className={`tingwu-icon ${className}`} size={size} {...rest}>
      <IconBarContent rotate={rotate} color={color}>
        <TYIcon type={type} size={size} />
      </IconBarContent>
    </IconContainer>
  );
});
