import styled from "styled-components";

export const Wrapper = styled.div<{
  miniMode?: boolean;
}>`
  display: flex;
  align-items: center;

  .ant-input {
    width: ${props => (props.miniMode ? 140 : 300)}px;
    height: 24px;
    border-radius: 4px;
    border: 1px solid var(--Text_Primary);
    line-height: 16px;
    font-size: 12px;
    padding: 0 10px;
    box-shadow: none;
    outline: none;
    transition: width 0.2s;

    :focus {
      box-shadow: none;
      /* outline: 1px solid rgba(96,92,229,0.20); */
    }
  }
`;

export const Button = styled.div<{
  primary?: boolean;
}>`
  user-select: none;
  touch-action: manipulation;
  font-size: 12px;
  font-weight: 500;
  line-height: 30px;
  padding: 0 8px;
  border-radius: 99px;
  height: 30px;
  cursor: pointer;
  transition: all 0.2s;
  border: 1px solid var(--Line_Brand_Light);
  background-color: var(--Fill_Background_Light);
  color: var(--Text_Primary);
  &:hover {
    border-color: var(--Line_Heavy);
    color: var(--Text_Caption);
  }

  ${props =>
    props.primary &&
    `
    background-color: var(--Fill_Brand_Inverse);
    border: none;
    color: var(--Text_Brand_Primary);
    &:hover {
      background-color: var(--Fill_Brand_Primary);
      color: var(--Text_Brand_Primary);
    }
    &:active {
      background-color: var(--Fill_Brand_Primary);
      color: var(--Text_Brand_Primary);
    }
  `}
`;

export const DropdownOverlay = styled.div`
  background: var(--Fill_Background_Light);
  box-shadow:
    0 3px 6px -4px rgba(39, 38, 77, 0.12),
    0 6px 16px 0 rgba(39, 38, 77, 0.08),
    0 9px 28px 8px rgba(39, 38, 77, 0.05);
  border-radius: 4px;
  padding: 20px 0 12px 0;
  user-select: none;
`;

export const CompanyPeopleList = styled.div`
  max-height: 240px;
  display: flex;
  flex-direction: column;
  overflow-y: auto;
  overflow-x: hidden;
`;

export const CompanyPeople = styled.div`
  cursor: pointer;
  display: flex;
  align-items: center;
  height: 60px;
  padding: 0 24px;
  flex-shrink: 0;
  &:hover {
    background-color: rgba(96, 92, 229, 0.08);
  }
`;

export const CompanyPeopleAvatar = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  margin-right: 8px;
  overflow: hidden;
  &,
  img {
    width: 32px;
    height: 32px;
    border-radius: 32px;
  }
`;

export const CompanyPeopleInfo = styled.div`
  flex: 1 1;
  display: flex;
  flex-direction: column;
  overflow: hidden;
`;

export const CompanyPeopleTitle = styled.div`
  font-size: 14px;
  line-height: 24px;
  color: #27264d;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;

  .highlight {
    color: #605ce5;
  }
`;

export const CompanyPeopleSubTitle = styled.div`
  font-size: 12px;
  color: rgba(39, 38, 77, 0.65);
  line-height: 20px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`;

export const CurrentListTitle = styled.div`
  height: 20px;
  font-weight: 400;
  font-size: 14px;
  color: var(--Text_Primary);
  letter-spacing: 0;
  line-height: 20px;
  position: relative;
  z-index: 1;
  margin-left: 24px;
`;

export const CurrentListDescribe = styled.div`
  width: 228px;
  font-weight: 400;
  font-size: 12px;
  color: var(--Text_Caption);
  letter-spacing: 0;
  line-height: 20px;
  margin-bottom: 10px;
  position: relative;
  z-index: 1;
  margin-left: 24px;
`;

export const RelatedSpeakerList = styled.div`
  max-height: 195px;
  overflow: hidden;
`;

export const RelatedSpeakerListContain = styled.div`
  display: flex;
  flex-wrap: wrap;
  overflow-y: auto;
  max-height: 153px;
  padding-left: 24px;
  padding-right: 16px;
`;

export const StarContainer = styled.div<{
  isColleted?: boolean;
}>`
  width: 15px;
  height: 15px;
  margin-top: -4px;
  color: #7d7d94;
  &:hover {
    color: ${props => (props.isColleted ? "#474667" : "#fccc75")};
  }
`;

export const CommonUseSpeakeLine = styled.div`
  height: 1px;
  width: 254px;
  background-color: rgba(39, 38, 77, 0.12);
  position: sticky;
  top: 0;
  margin-top: 9px;
  margin-bottom: 12px;
`;

export const CurrentCommonUseListTitle = styled.div`
  display: flex;
  align-items: center;
  width: 100%;
  font-weight: 400;
  color: var(--Text_Primary);
  letter-spacing: 0;
  line-height: 20px;
  position: relative;
  z-index: 1;
`;

export const CurrentCommonUseListDescribe = styled.div`
  width: 100%;
  font-weight: 400;
  font-size: 12px;
  color: var(--Text_Caption);
  letter-spacing: 0;
  line-height: 20px;
  margin-bottom: 5px;
  padding-right: 24px;
  position: relative;
  z-index: 1;
`;

export const CommonUseListTitleWord = styled.div`
  margin-right: 4px;
  margin-top: -1px;
  font-size: 14px;
`;

export const CommonUseListContain = styled.div`
  display: flex;
  flex-wrap: wrap;
  width: 100%;
  position: relative;
  top: 0;
  overflow: scroll;
`;

export const CommonUseSpeakerList = styled.div`
  padding: 0 2px 0 24px;
  overflow: hidden;
`;

export const RelatedSpeakerText = styled.div`
  flex: 1 1;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`;

export const DeleteIconBox = styled.div`
  display: flex;
  align-items: center;
  margin: 0 3px;

  color: #7d7d94;
  &:hover {
    color: #605ce5;
  }
`;

export const StarTooltip = styled.div`
  position: absolute;
  z-index: 1;
  top: -36px;
  left: -60px;
  height: 31px;
  width: 100px;
`;

export const DeleteTooltip = styled.div`
  position: absolute;
  z-index: 1;
  top: -36px;
  left: -15px;
  height: 31px;
  width: 40px;
`;

export const DeleteTripleContent = styled.div`
  width: 0;
  height: 0;
  border-top: 7px solid rgb(39, 38, 77);
  border-right: 4px solid transparent;
  border-left: 5px solid transparent;
  margin-top: -1px;
  z-index: 1;
  position: absolute;
  left: 17px;
`;

export const StarTooltipText = styled.div`
  background-color: rgb(39, 38, 77);
  box-shadow: rgb(90 68 151 / 10%) 0 2px 8px 0;
  border-radius: 8px;
  font-weight: 400;
  font-size: 12px;
  color: rgb(255, 255, 255);
  padding: 4px 8px;
  line-height: 20px;
`;

export const TripleContent = styled.div`
  width: 0;
  height: 0;
  border-top: 7px solid rgb(39, 38, 77);
  border-right: 4px solid transparent;
  border-left: 5px solid transparent;
  margin-top: -1px;
  z-index: 1;
  position: absolute;
  left: 62px;
`;

export const StarBox = styled.div`
  margin-left: 1px;
  position: relative;
`;

export const RelatedSpeaker = styled.div`
  border: 1px solid var(--Line_Brand_Secondary);
  border-radius: 16px;
  height: 30px;
  padding: 3px;
  display: flex;
  align-items: center;
  cursor: pointer;
  margin-right: 8px;
  margin-bottom: 8px;
  font-size: 12px;
  max-width: 200px;
  .relatedSpeakerText {
    margin-left: 9px;
    margin-right: 13px;
    color: var(--Text_Primary);
  }
  .starTooltip {
    display: none;
  }
  .star {
    display: none;
    &:hover {
      .starTooltip {
        display: block;
      }
    }
  }
  &:hover {
    border: 1px solid var(--Text_Primary);
    .star {
      display: block;
      margin-right: 3px;
    }
    .relatedSpeakerText {
      margin-left: 1px;
      margin-right: 2px;
    }
  }
`;

export const RelatedCommonUseSpeaker = styled.div`
  border: 1px solid var(--Line_Brand_Secondary);
  border-radius: 16px;
  height: 30px;
  padding: 3px;
  display: flex;
  align-items: center;
  cursor: pointer;
  margin-right: 8px;
  margin-bottom: 8px;
  font-size: 12px;
  max-width: 200px;
  .relatedSpeakerText {
    margin-left: 6px;
    margin-right: 9px;
    color: var(--Text_Primary);
  }
  .deleteTooltip {
    display: none;
  }
  .deleteIcon {
    display: none;
    &:hover {
      .deleteTooltip {
        display: block;
      }
    }
  }
  &:hover {
    border: 1px solid var(--Text_Primary);
    .deleteIcon {
      display: flex;
      align-items: center;
    }
    .relatedSpeakerText {
      margin-left: 0;
      margin-right: 0;
    }
  }
`;

export const RelatedSpeakerIcon = styled.div`
  margin-right: 4px;
  overflow: hidden;
  &,
  img {
    width: 24px;
    height: 24px;
    border-radius: 24px;
  }
`;

export const DefaultAvatarIcon = styled.div`
  width: 24px;
  height: 24px;
  background: url("https://img.alicdn.com/imgextra/i2/O1CN01bYk4v01bIU3act9rE_!!6000000003442-2-tps-72-72.png");
  background-position: center 0;
  background-size: cover;
`;

export const HorizontalDivider = styled.div`
  background-color: rgba(39, 38, 77, 0.12);
  height: 1px;
  margin: 19.5px 24px;
`;

export const AlibabaEmpty = styled.div`
  font-size: 14px;
  color: rgba(39, 38, 77, 0.65);
  line-height: 24px;
  padding: 0 24px;
`;
