import styled from "styled-components";

export const Wrapper = styled.div`
  &:after {
    content: " ";
    display: block;
    height: 0;
    background-color: var(--Fill_Background_Light);
  }
`;

export const Background = styled.div`
  width: calc(100% + 2px);
  margin-left: -1px;
  height: 50px;
  background-color: var(--Fill_Background_Light);
  display: flex;
  flex-direction: column;
  justify-content: flex-end;
  align-items: end;
`;

export const ReturnButton = styled.div`
  background-color: rgb(44, 44, 54, 0.8);
  box-shadow: 0 2px 8px 0 rgba(90, 68, 151, 0.12);
  color: #fff;
  border-radius: 8px;
  font-size: 16px;
  line-height: 22px;
  height: 32px;
  width: 32px;
  display: flex;
  justify-content: center;
  align-items: center;
  cursor: pointer;
  user-select: none;
  :hover {
    background-color: rgba(39, 38, 77, 0.4);
  }
  /* svg {
    margin-right: 8px;
  } */
`;
