import styled, { css } from "styled-components";
import { config } from "../../config";
import { QnaActive } from "./paragraphContent";
import { AssistantActiveType } from "@tingwu/sphere";

const { textEditor, paragraph } = config.theme;

const { speaker, speakerAvatar } = paragraph.heading;

export const Wrapper = styled.div<{
  sticky?: boolean;
  visible?: boolean;
}>`
  display: ${props => (props.visible === false ? "none" : "block")};
  position: ${props => (props.sticky ? "sticky" : "static")};
  z-index: 200;
  bottom: 0;
  margin-top: ${props => props.theme.paragraphMarginTop}px;
  margin-bottom: ${props => props.theme.paragraphMarginBottom}px;
  &:first-child {
    margin-top: 0;
  }
  &:last-child {
    margin-bottom: 0;
  }

  ${props =>
    props.sticky &&
    `
    &:after {
      content: '';
      display: block;
      position: absolute;
      bottom: -10px;
      left: -10px;
      right: -10px;
      height: 13px;
      background: var(--Fill_Background_Light);
    }
  `}
`;

export const ParagraphWrapper = styled.div<{
  isUnfix?: boolean;
}>`
  position: relative;
  ${props =>
    props.isUnfix &&
    css`
      &:before,
      &:after {
        content: "";
        display: block;
        position: absolute;
        top: 0;
        bottom: 0;
        width: 10px;
        background: var(--Fill_Background_Light);
      }
      &:before {
        left: -10px;
      }
      &:after {
        right: -10px;
      }
    `}
`;

export const ParagraphSpeaking = styled.div`
  font-weight: 500;
  font-size: 12px;
  color: #605ce5;
  line-height: 20px;
  padding: 6px 0;
  background: #f2f5fb;
`;

export const ParagraphHeadingStyled = styled.div<{
  showBackground?: boolean;
  enableShowSpeaker?: boolean;
}>`
  display: flex;
  align-items: center;
  padding-bottom: ${props => (props.enableShowSpeaker ? "10px" : "4px")};
  height: 32px;
  background-color: var(--Fill_Background_Light);
`;

export const ParagraphHeadingSpeakerWrapper = styled.div`
  flex: 1;
  display: flex;
`;

export const ParagraphAvatar = styled.div`
  border-radius: ${speakerAvatar.borderRadius}px;
  overflow: hidden;
  display: flex;
  justify-content: center;
  align-items: center;
  color: #fff;
  margin-right: 12px;
  user-select: none;
  flex-shrink: 0;

  &,
  img {
    width: ${speakerAvatar.width}px;
    height: ${speakerAvatar.height}px;
  }
`;

export const ParagraphSpeakerWrapper = styled.div<{
  visible?: boolean;
  disableHoverEffect?: boolean;
}>`
  align-items: center;
  display: ${props => (props.visible ? "flex" : "none")};
  flex: 1;
  position: relative;
  background-color: var(--Fill_Background_Light);
  ${props =>
    !props.disableHoverEffect &&
    `
      &:hover {
        .time {
          opacity: 0;
          visibility: hidden;
          width: 0;
        }
        .speaker {
          color: var(--Text_Disabled);
          .anticon {
            display: inline-flex;
            font-size: 16px;
          }
        }
      }
    `}
`;

export const ParagraphSpeaker = styled.div<{
  readonly?: boolean;
}>`
  font-size: 12px;
  line-height: 18px;
  color: ${speaker.color};
  margin-right: 8px;
  transition: all 0.2s;
  cursor: ${props => (props.readonly ? "default" : "pointer")};
  display: flex;
  align-items: center;
  user-select: none;
  flex-shrink: 1;
  overflow: hidden;

  .anticon {
    margin-left: 8px;
    display: none;
  }
`;

export const DefaultAvatar = styled.div<{
  defaultAvatarImg?: string;
}>`
  width: ${speakerAvatar.width}px;
  height: ${speakerAvatar.height}px;
  background: url(${props =>
    props.defaultAvatarImg ||
    "https://img.alicdn.com/imgextra/i3/O1CN01mqaz5k1gzbSjkrFAW_!!6000000004213-2-tps-339-339.png"});
  background-position: center 0;
  background-size: cover;
`;

export const ParagraphSpeakerText = styled.span<{
  isHighlight?: boolean;
}>`
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  color: ${({ isHighlight }) => (isHighlight ? "var(--Text_Primary)" : "var(--Text_Caption)")};
`;

export const ParagraphHeadingTime = styled.div<{
  readonly?: boolean;
  isHighlight?: boolean;
}>`
  font-size: ${speaker.fontSize}px;
  line-height: 18px;
  color: ${({ isHighlight }) => (isHighlight ? "var(--Text_Caption)" : speaker.color)};
  opacity: 1;
  transition: all 0.2s;
  cursor: ${props => (props.readonly ? "default" : "text")};
  user-select: none;
  flex-shrink: 0;
`;

export const ParagraphStyledWrapper = styled.div`
  position: relative;
  user-select: none;
  background-color: var(--Fill_Background_Light);
`;
// #605CE5
export const QAMarkStyled = styled.div<{
  bgColor: string;
  fontColor: string;
  large?: boolean;
}>`
  position: absolute;
  height: 20px;
  width: ${props => (props.large ? "28px" : "20px")};
  display: flex;
  justify-content: center;
  align-items: center;
  font-weight: 600;
  -webkit-font-smoothing: antialiased;
  font-size: 12px;
  background-color: ${props => props.bgColor};
  color: ${props => props.fontColor};
  border-radius: 8px 0 4px 0;
  top: 0;
  left: 0;
  z-index: 11;
`;

export const ParagraphStyled = styled.div<{
  focus: boolean;
  isUnfix?: boolean;
  qnaActive: number;
  isHighlight?: boolean;
  showOutline?: boolean; // default: true
  fileModel?: string;
}>`
  box-sizing: border-box;
  display: flex;
  flex-direction: column;
  align-items: center;
  min-height: ${textEditor.lineHeight + paragraph.paddingVertical * 2}px;
  border-radius: ${paragraph.borderRadius}px;
  background-color: var(--Fill_Background_Light);
  overflow: hidden;
  position: relative;
  z-index: 10;
  word-break: break-word;
  padding: 0;
  transition: background-color 0.5s ease;
  /* border: 1px solid transparent; */
  ${props => props.fileModel === "box" && "border: 1px solid rgba(39,38,77,0.10);"}

  ${props => {
    if (!props.qnaActive) return "";
    if (
      (props.qnaActive === QnaActive.mainPoin || props.qnaActive === QnaActive.answer) &&
      !props.isHighlight
    ) {
      // return 'border: 1px solid transparent;';
    }
    if (
      (props.qnaActive === QnaActive.question || props.qnaActive === QnaActive.questionAndanswer) &&
      !props.isHighlight
    ) {
      // return 'border: 1px solid transparent;';
    }
    return "";
  }}

  ${props => !props.isUnfix && "margin: 0 0 6px;"}


  ${props =>
    props.focus &&
    css`
      background-color: var(--Line_Brand_Light);
      border: 1px solid transparent;
      box-shadow: 0 0 0 1px var(--Line_Secondary);
    `}

  ${props =>
    !props.focus &&
    css`
      &:hover {
        box-shadow: 0 0 0 1px var(--Line_Secondary);
      }
    `}

  ${props =>
    props.focus &&
    props.isHighlight &&
    css`
      box-shadow: 0 0 0 1px var(--Line_Heavy);
    `}

  ${props =>
    !props.focus &&
    props.isHighlight &&
    css`
      &:hover {
        box-shadow: 0 0 0 1px var(--Line_Heavy);
      }
    `}
  
  &:hover {
    .fix-button {
      opacity: 1;
    }
  }
`;
export const ParagraphInner = styled.div`
  flex: 1;
`;

export const UnfixText = styled.span<{
  isHighlight?: boolean;
}>`
  user-select: none;
  font-size: ${textEditor.fontSize}px;
  line-height: ${textEditor.lineHeight}px;
  color: var(--Text_Disabled);
`;

export const Mask = styled.div`
  position: absolute;
  top: -1;
  height: 1;
  left: 0;
  right: 0;
`;

export const MaskInner = styled.div`
  position: absolute;
  bottom: 0;
  left: 0;
  right: 0;
`;

export const ParagraphOrigin = styled.div<{
  showTranslate?: boolean;
  showTextPolish?: boolean;
  isHighlight?: boolean;
  isLivingMode?: boolean;
  isUnfix?: boolean;
  isPlaying?: boolean;
  qnaActive: number;
  isAnaQ?: boolean;
  meetingAgendaActive?: boolean;
  aiReviewActive?: AssistantActiveType | null;
}>`
  display: flex;
  align-items: flex-start;
  width: 100%;
  padding: ${props => props.theme.paragraphVerticalPadding}px
    ${props => props.theme.paragraphHorizontalPadding}px;
  background-color: var(--Fill_Tertiary);
  /* border: 1px solid transparent; */
  box-sizing: border-box;
  /* TODO QA style  */
  ${props => {
    if (props.showTranslate) return "";
    if (props.showTextPolish) return "";
    if (!props.isUnfix && props.meetingAgendaActive)
      return "background-color: var(--Fill_Brand_Background);";
    if (!props.qnaActive) return "";
    if (props.qnaActive === QnaActive.mainPoin || props.qnaActive === QnaActive.answer) {
      return "background-color: var(--Fill_Brand_Background);";
    }
    if (props.qnaActive === QnaActive.question || props.qnaActive === QnaActive.questionAndanswer) {
      return "background-color: var(--Fill_Brand_Background);";
    }
    return "";
  }}

  ${props => {
    if (props.isLivingMode) return "";
    if (props.aiReviewActive === AssistantActiveType.originActive) {
      return `background-color: var(--Fill_Brand_Background);
      border: 1px solid transparent;
      `;
    }
    return "";
  }}

  ${props =>
    props.isUnfix &&
    `
    min-height: 104px;
  `}

  ${props =>
    (props.showTranslate || props.showTextPolish) &&
    `
    padding-bottom: 8px;
  `}

  ${props =>
    props.isHighlight &&
    css`
      background-color: var(--Fill_Brand_Background);
      color: ${props.isPlaying ? "rgba(255, 255, 255, 0.6)" : "var(--Text_Brand_Primary)"};
    `}

  ${props =>
    !props.isHighlight &&
    css`
      color: ${props.isPlaying ? "rgba(39,38,77,0.35)" : "var(--Text_Secondary)"};
    `}
`;

export const ParagraphHeadingExtra = styled.div`
  display: flex;
  justify-content: flex-end;
`;
