import { Controller, PID } from "@tingwu/core";
import React, { memo, useEffect, useState, useTransition } from "react";

export interface ParagraphContentWrapperProps {
  controller: Controller;
  pid?: PID; // no pid means emptyUnfix
}

export const ParagraphContentWrapper: React.FC<
  React.PropsWithChildren<ParagraphContentWrapperProps>
> = memo(props => {
  const { controller, pid, children } = props;
  const [inited, setInited] = useState(false);
  const [isPending, startTransition] = useTransition();

  useEffect(() => {
    const pids = controller.getPids();
    if (!pid || pids.indexOf(pid) < 50) {
      setInited(true);
    } else {
      startTransition(() => {
        setInited(true);
      });
    }
  }, [controller, pid]);

  if (!inited || isPending) {
    return null;
  }

  return children as React.ReactElement<any, any>;
});
