import React, { useEffect, useCallback, memo } from "react";
import { Wrapper, ContentText, LintBotton, CloseButton } from "./styled";
import { useTranscriptionHooks } from "../../controller";
import { Controller } from "@tingwu/core";
import { TYIcon } from "@tingwu/design";

export interface NoRecordTipProps {
  controller: Controller;
  visible: boolean;
  onVisibleChange: (v: boolean) => void;
}

// 异常帮助文档页跳转
export const NoRecordTip: React.FC<NoRecordTipProps> = memo(props => {
  const { controller, visible, onVisibleChange } = props;

  const { onEvent } = useTranscriptionHooks(controller, ["onEvent"]);

  const gotoExceptionHelp = useCallback(() => {
    onEvent && onEvent("clickNoWordHelp", {});
    let { origin } = location;
    if (location.href.includes("tongyi.aliyun.com/")) {
      origin = "https://tingwu.aliyun.com";
    }
    const url = `${origin}/helpcenter/recordhelp`;
    window.open(url);
  }, [onEvent]);

  // close tip change showSpeakerTip
  const closeNoRecordTip = useCallback(() => {
    onVisibleChange(false);
    onEvent && onEvent("detectEmptyContentClose", {});
  }, [onEvent, onVisibleChange]);

  useEffect(() => {
    return controller.on("addFixParagraph", () => {
      controller.clearNoRecordTip();
    });
  }, [controller]);

  if (!visible) {
    return null;
  }

  if (location.href.includes("tongyi.aliyun.com/") || location.href.includes("tongyi.cn")) {
    return (
      <Wrapper>
        <TYIcon
          type={"icon-warningCircle-line"}
          size={20}
          style={{ color: "var(--Caution_Default)" }}
        />
        <ContentText data-e2e-test-id="trans_noResult_div">
          无识别结果？请检查录音设备是否正常
        </ContentText>
        <CloseButton onClick={closeNoRecordTip}>
          <TYIcon type={"icon-false-line"} style={{ fontSize: 16 }} />
        </CloseButton>
      </Wrapper>
    );
  } else {
    return (
      <Wrapper>
        <TYIcon
          type={"icon-warningCircle-line"}
          style={{ color: "var(--Caution_Default)" }}
          size={16}
        />
        <ContentText data-e2e-test-id="trans_noResult_div">无识别结果？</ContentText>
        <LintBotton onClick={gotoExceptionHelp}>查看帮助</LintBotton>
        <CloseButton onClick={closeNoRecordTip}>
          <TYIcon type={"icon-false-line"} style={{ fontSize: 16 }} />
        </CloseButton>
      </Wrapper>
    );
  }
});
