import styled from "styled-components";

export const Wrapper = styled.div`
  background-color: var(--Fill_Tertiary);
  border-radius: 16px;
  font-size: 15px;
  color: var(--Text_Primary);
  width: 403px;
  height: 48px;
  line-height: 24px;
  padding: 0 12px;
  display: flex;
  align-items: center;
  position: relative;
  margin-left: 11px;
  position: absolute;
  right: -24px;
  z-index: 30;
`;

export const Text = styled.div`
  margin-left: 6px;
  margin-right: 8px;
  min-width: 252px;
`;

export const CloseButton = styled.div`
  width: 12px;
  height: 12px;
  display: flex;
  justify-content: center;
  align-items: center;
  cursor: pointer;
  position: relative;
  color: var(--Text_Disabled);
  &:hover {
    color: var(--Text_Primary);
  }
  &:after {
    position: absolute;
    top: -2px;
    left: -2px;
    right: -2px;
    bottom: -2px;
  }
`;

export const Triple = styled.div`
  width: 0;
  height: 0;
  border-top: 4px solid transparent;
  border-bottom: 5px solid transparent;
  position: absolute;
  left: -7px;
  border-right: 7px solid var(--Fill_Tertiary);
`;
