import React, { useState, useEffect, memo, useMemo } from "react";
import { fill } from "lodash-es";

interface DynamicDotsProps {
  style?: React.CSSProperties;
}

export const DynamicDots: React.FC<DynamicDotsProps> = memo(props => {
  const { style } = props;
  const [count, setCount] = useState<number>(0);

  useEffect(() => {
    const interval = setInterval(() => {
      setCount(p => p + 1);
    }, 300);
    return () => {
      clearInterval(interval);
    };
  }, []);

  const dots = useMemo(() => {
    return fill(Array(count % 4), ".").join("");
  }, [count]);

  return <span style={style}>{dots}</span>;
});
