// Jest config for tingwu-transcription package
const path = require('path');

const rootConfig = require('../../jest.config.js');

module.exports = {
  ...rootConfig,
  rootDir: path.resolve(__dirname, '../..'),
  testMatch: ['<rootDir>/packages/tingwu-transcription/**/__tests__/**/*.test.{ts,tsx}'],
  setupFilesAfterEnv: ['<rootDir>/jest.setup.js'],
  transform: {
    '^.+\\.(ts|tsx)$': ['ts-jest', {
      tsconfig: {
        jsx: 'react-jsx',
        esModuleInterop: true,
        allowSyntheticDefaultImports: true,
        skipLibCheck: true,
      },
    }],
  },
  moduleNameMapper: {
    ...rootConfig.moduleNameMapper,
    '\\.(less|css)$': 'identity-obj-proxy',
    // Map lodash-es to lodash (CommonJS) for testing
    '^lodash-es$': 'lodash',
    '^lodash-es/(.*)$': 'lodash/$1',
  },
};

