export enum Env {
  DEV = 'dev',
  PRE = 'pre',
  PROD = 'prod',
}

// 获取环境
export const getEnv = (): Env => {
  if (
    window.location.host.startsWith('localhost') ||
    window.location.host.startsWith('dev')
  ) {
    return Env.DEV;
  } else if (window.location.host.startsWith('pre')) {
    return Env.PRE;
  } else {
    return Env.PROD;
  }
};

const _tingwuWindow = (): any => {
  return window;
};
// node 环境 Window
export const tingwuWindow = _tingwuWindow();
