import styled from 'styled-components';

export const LoadingWrapper = styled.div`
  height: 100%;
  width: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  svg {
    width: 40px;
    height: 40px;
    display: block;
  }

  /* 整圈旋转容器 */
  .spin {
    transform-origin: 32px 32px; /* 圆心为旋转中心 */
    animation: spin 2s linear infinite; /* 匀速旋转 */
  }

  /* 背景轨道 */
  .track {
    fill: none;
    stroke: #f3f0ff; /* 轨道颜色 */
    stroke-width: 6; /* 粗细 */
  }

  /* 前景弧线 */
  .arc {
    fill: none;
    stroke: url(#g); /* 使用渐变 */
    stroke-width: 6;
    stroke-linecap: round;
    stroke-dasharray: 10 90; /* 初始短弧 + 空隙 */
    animation: dash 1.8s cubic-bezier(0.45, 0, 0.55, 1) infinite both; /* 呼吸效果 */
  }

  /* 旋转动画 */
  @keyframes spin {
    to {
      transform: rotate(360deg);
    }
  }

  /* 呼吸 dash 动画：确保 0% 与 100% 对齐，实现无缝循环 */
  @keyframes dash {
    0% {
      stroke-dasharray: 10 90;
      stroke-dashoffset: 0;
    }
    50% {
      stroke-dasharray: 35 65;
      stroke-dashoffset: -25;
    }
    100% {
      stroke-dasharray: 10 90;
      stroke-dashoffset: -100;
    }
  }
`;
