import { TYProvider } from '@tingwu/design';
import { useCallback } from 'react';
import { docBaseHooks, docTagHooks } from '../../../../documentModel';
import LeftContent from '../../components/atomicComponent/Content/LeftContent';
import LeftTopBar from '../../components/atomicComponent/Content/LeftTopBar';
import RightContent from '../../components/atomicComponent/Content/RightContent';
import PPTPhotoViewer from '../../components/atomicComponent/WuLab/PPTSummaryCard/PPTPhotoViewer';
import { DetailLayout } from '../detailLayout';
import { LeftContentLoading } from './leftContentLoading';
import { TranscriptionFailContent, TranscriptionFailWrap } from './styled';
import { IProps } from './types/props';

const errorMsgMap = {
  'TSC.AudioFileSize': '音频文件超出6G限制，请更换体验文件',
  'TSC.AudioSampleRate':
    '不支持该音频采样率，请更换8K/16K/24K/48K采样率的体验文件',
  ServerError: '系统出错了',
  'TSC.AudioDuration': '音频时长超出6小时限制，请更换体验文件',
  'TSC.AudioFormat': '无效的音频格式，请更换体验文件',
  'TSC.FileType': '无效文件，请更换音视频文件后，再进行体验文件',
  'TSC.TextFileIllegal': '疑似转写内容有安全风险，请替换体验文件或更新文本内容',
};
const File = (props: IProps) => {
  const { docBaseData }: any = docBaseHooks.useDocBaseData();
  const { tag } = docBaseData || {};
  const { docTagData } = docTagHooks.useDocTagData();

  const createFullScreenContentGenerator = useCallback(
    (type: 'left' | 'right') => {
      if (type === 'left' && docBaseData.transcriptionLoading) {
        return () => <LeftContentLoading />;
      }
      if (type === 'left') {
        return () => <LeftContent {...props} />;
      }

      return () => <RightContent />;
    },
    [props, docBaseData.transcriptionLoading],
  );

  // 处理点击事件
  const handleClickNavigateTool = () => {
    window.history.back();
  };

  const renderTitleRightTools = () => {
    return <LeftTopBar />;
  };

  if (docTagData?.status === 2) {
    return (
      <TYProvider>
        <TranscriptionFailWrap>
          <TranscriptionFailContent>
            <div className="contentTitle">生成失败</div>
            <div className="contentDesc">
              {docTagData?.errorCode && errorMsgMap[docTagData?.errorCode]
                ? errorMsgMap[docTagData?.errorCode]
                : errorMsgMap.ServerError}
            </div>
          </TranscriptionFailContent>
        </TranscriptionFailWrap>
      </TYProvider>
    );
  }

  const customPageStyle = { border: '1px solid var(--Line_Secondary)' };
  return (
    <TYProvider>
      <div
        id="tingwu2_file_container"
        style={{
          overflow: 'hidden',
          height: '100%',
          position: 'relative',
          borderRadius: 0,
        }}
      >
        <DetailLayout
          leftMinWidth={590}
          pageContentStyle={{
            background: 'transparent',
            ...customPageStyle,
          }}
          renderNavRightContent={() => renderTitleRightTools()}
          pageHeaderStyle={{ background: 'var(--Fill_Background_Light)' }}
          rightContentWidth={'50%' as any}
          title={'智能纪要'}
          onClickBackBtn={() => {
            handleClickNavigateTool();
          }}
          renderLeftContent={createFullScreenContentGenerator('left')}
          renderRightContent={createFullScreenContentGenerator('right')}
          type="custom"
        />
        <PPTPhotoViewer />
      </div>
    </TYProvider>
  );
};

export default File;
