import { Loading } from '../../../../components/BaseCompontents/Loading';

import { useEffect, useState } from 'react';
import { useDispatch } from 'react-redux';
import { useDataHooks } from '../../components/businessCommon/separateHooks/dataShare';
import { ContentTabType } from '../../utils/config';

import {
  docBaseHooks,
  docRouteHooks,
  documentHooks,
  eDocScene,
  iDocIDType,
} from '../../../../documentModel';
import { getRouteDocIdService } from '../../../../documentModel/docRoute/docRoute.operator';
import { setCommonData } from '../../components/businessCommon/constVariable';

import { contentTabActiveState } from '../../../../recoils';
import { fileShowState } from '../../../../recoils/docFile';
import { RecoilRoot, useRecoilState, useSetRecoilState } from 'recoil';
import File from '../pageEdit';

export default () => {
  const { controller, agendaSummaryController } = useDataHooks(true);

  const dispatch = useDispatch();
  /** 一些内部状态 */
  const [fileShow, setFileShow] = useRecoilState(fileShowState);

  /** 正常业务逻辑 */
  const { documentData, resetDocumentCurtData, clearDocumentData } =
    documentHooks.useDocumentData();
  const { docId, docErrorCode, docScene } = documentData;
  const { initRouteData } = docRouteHooks.useDocRouteData();
  const { docBaseData, initDocBaseData } = docBaseHooks.useDocBaseData();

  /**
   *  *************************************************************
   *  **********************  初始化页面   **************************
   *  *************************************************************
   */
  const [cacheDocId, setCacheDocId] = useState<iDocIDType | null>(null);

  useEffect(() => {
    const tempDocId = getRouteDocIdService();
    if (
      tempDocId !== docId &&
      (typeof tempDocId === 'string' || typeof tempDocId === 'number')
    ) {
      setCacheDocId(tempDocId);
      clearDocumentData();
    }
  }, [cacheDocId, clearDocumentData, docId]);
  const setContentTabActive = useSetRecoilState(contentTabActiveState);
  useEffect(() => {
    setContentTabActive(ContentTabType.introduction);
  }, [setContentTabActive]);

  useEffect(() => {
    (async () => {
      if (!cacheDocId) return;
      setFileShow(false);
      let routeDocId = '';
      let routeScene = eDocScene.discovery;

      const { routeDocId: id, routeScene: scene } = await initRouteData();
      routeDocId = `${id}`;
      routeScene = scene;
      await initDocBaseData(`${routeDocId}`, routeScene);
    })();

    // 页面销毁重置当前文档数据
    return () => {
      resetDocumentCurtData();
      clearDocumentData();
      window.sessionStorage.removeItem('scene');
    };
  }, [
    cacheDocId,
    clearDocumentData,
    dispatch,
    initDocBaseData,
    initRouteData,
    resetDocumentCurtData,
    setFileShow,
  ]);

  useEffect(() => {
    setCommonData('transId', docId);
    setCommonData('model', docScene);
  }, [docId, docScene]);

  useEffect(() => {
    /** 拿到了 业务数据 */
    if (docBaseData) {
      const { scene } = docBaseData || {};

      /** 数据正常的 投喂 */
      if (!docErrorCode) {
        setFileShow(true);
      }
    }
  }, [docBaseData]);

  // loading 页面， box 弹窗不需要显示这个loading
  if (!(controller && agendaSummaryController) && !docErrorCode) {
    return <Loading />;
  }

  return fileShow ? (
    <RecoilRoot>
      {/* {isShareScene && <NotSupportBrowserPrompt />} */}
      <File innerLogin />
    </RecoilRoot>
  ) : (
    <Loading />
  );
};
