import { useMemo } from 'react';
import {
  LeftContent,
  LeftTitle,
  MidLine,
  Page,
  PageContent,
  PageContentInner,
  PageDetailContainer,
  PageHeader,
  PageHeaderInner,
  RightContent,
  Title,
} from './styled';
export const DetailLayout = (props) => {
  const {
    maxPageWidth,
    minPageWidth,
    pageClassName,
    pageStyle,
    pageHeaderClassName,
    pageHeaderStyle,
    pageContentInnerClassName,
    pageContentInnerStyle,
    pageContentStyle,
    rightContentWidth,
    rightContentStyle,
    title,
    renderNavRightContent,
  } = props;

  const rightStyle = useMemo(() => {
    if (rightContentWidth) {
      return {
        width: rightContentWidth,
        ...rightContentStyle,
      };
    }
    return {
      width: '50%',
      ...rightContentStyle,
    };
  }, [rightContentWidth, rightContentStyle]);
  return (
    <Page minWidth={minPageWidth} className={pageClassName} style={pageStyle}>
      <PageHeader className={pageHeaderClassName} style={pageHeaderStyle}>
        <PageHeaderInner maxWidth={maxPageWidth}>
          <Title>{title}</Title>
        </PageHeaderInner>
      </PageHeader>
      <PageContent style={pageContentStyle}>
        <PageContentInner
          maxWidth={maxPageWidth}
          className={pageContentInnerClassName}
          style={pageContentInnerStyle}
        >
          <PageDetailContainer>
            <LeftContent leftMinWidth={props.leftMinWidth}>
              <div className="navTop">
                <div className="navTopLf">
                  <LeftTitle>对话内容</LeftTitle>
                </div>
                {props.renderNavRightContent?.()}
              </div>
              {props.renderLeftContent?.()}
            </LeftContent>
            <MidLine />
            <RightContent style={rightStyle}>
              {props.renderRightContent?.()}
            </RightContent>
          </PageDetailContainer>
        </PageContentInner>
      </PageContent>
    </Page>
  );
};
