import styled from 'styled-components';

const CardHeaderContainer = styled.div`
  user-select: none;
  font-weight: 500;
  font-size: 14px;
  /* color: var(--Text_Primary); */
  color: var(--Text_Primary);
  letter-spacing: 0;
  line-height: 24px;
  display: flex;
  align-items: center;
  justify-content: space-between;
  .line {
    display: inline-block;
    height: 10px;
    width: 3px;
    background-color: var(--Text_Primary);
    border-radius: 1.5px;
    margin-right: 8px;
  }
  :hover {
    .right {
      display: flex;
      align-items: center;
      cursor: pointer;
    }
  }
  .icon-item {
    font-size: 18px;
    color: var(--Text_Primary);
    :hover {
      color: var(--Text_Primary);
    }
  }
  .title {
    display: flex;
    align-items: center;
    cursor: default;
    .spokesManOpen {
      font-weight: 400;
      font-size: 12px;
      color: var(--Text_Primary);
      letter-spacing: 0;
      line-height: 20px;
      margin-left: 4px;
    }
    .linkButton {
      height: 22px;
      width: 24px;
      font-family: PingFangSC-Regular, var(--font-family);
      font-weight: 400;
      font-size: 12px;
      color: #615ced;
      letter-spacing: 0;
      line-height: 23px;
      display: inline-block;
      margin-left: 8px;
      cursor: pointer;
      &:hover {
        color: #7470e7;
      }
      &:active {
        color: #5b57ce;
      }
    }
    .text-wrap {
      -webkit-font-smoothing: antialiased;
      font-weight: 600;
    }
    .yuanwenIcon {
      margin-right: 3px;
      align-items: center;
      display: flex;
      .tingwu-icon {
        margin-left: -4px;
      }
    }
  }
`;

export { CardHeaderContainer };
