import React, { useCallback, useMemo, useRef, useState } from 'react';
// ***  三方包相关 ***
import { Tooltip } from '@tingwu/design';
// *** Model 层数据相关 ***
import { docSpeakerHooks } from '../../../../../../../documentModel';
// *** 工具相关 ***
import { getDefaultName } from '../../../../../../../utils/speakerUtils';
// *** 公共组件相关 ***
import { AvatarForSpeaker } from '../../../../../../../components/BaseCompontents/AvatarForSpeaker';
import { useRenderAvatar } from '../../../../../../../pages/docASR/components/atomicComponent/Paragraphs/hooks/useRenderAvatar';
import { iSpeakerSummaryItem } from './speakerSummaryItem.type';
// *** 样式文件相关 ***
import {
  AvatarContainer,
  Content,
  ContentContainer,
  Heading,
  SpeakerName,
  Wrapper,
} from './speakerSummaryItem.styled';

const SpeakerSummaryItem: React.FC<iSpeakerSummaryItem> = (props) => {
  const { summary, expanded = false, isExpandItem = false } = props;
  const { getSpeakerDataFromUid } = docSpeakerHooks.useDocSpeakerData();

  const nameRef = useRef<HTMLSpanElement | null>(null);

  const [showFullName, setShowFullName] = useState(false);

  const contentRef = useRef();

  const onMouseEnter = useCallback(() => {
    if (nameRef.current) {
      const { clientWidth, scrollWidth } = nameRef.current;
      if (clientWidth < scrollWidth) {
        setShowFullName(true);
      }
    }
  }, []);

  const onMouseLeave = useCallback(() => {
    setShowFullName(false);
  }, []);

  const content = useMemo(
    () =>
      summary.isTextTooShort ? '发言内容太少了，无总结内容哦' : summary.content,
    [summary.isTextTooShort, summary.content],
  );

  React.useEffect(() => {
    if (isExpandItem || expanded) {
      // ??? 为甚麽要修改props 的数据
      props.contentClassRef.current = 'opacityAnimation';
    }
  }, [isExpandItem, expanded, props.contentClassRef]);

  const speaker = useMemo(
    () => getSpeakerDataFromUid(summary?.uid),
    [getSpeakerDataFromUid, summary?.uid],
  );

  const name = useMemo(
    () =>
      speaker
        ? speaker.name || getDefaultName(speaker?.ui, true)
        : '未知发言人',
    [speaker],
  );

  const renderAvatarRef = useRef<React.ReactElement | null>();

  const { renderSpeakerAvatar: pgRenderSpeakerAvatar } = useRenderAvatar();
  const renderSpeakerAvatar = useMemo(() => {
    if (renderAvatarRef.current) {
      return renderAvatarRef.current;
    }
    const element = speaker ? (
      <AvatarForSpeaker {...speaker} avatarSize={24} />
    ) : (
      pgRenderSpeakerAvatar(summary?.uid)
    );

    renderAvatarRef.current = element;
    return element;
  }, [speaker, pgRenderSpeakerAvatar, summary?.uid]);

  const renderReviewSpokesPersonMode = useMemo(() => {
    if (isExpandItem) return null;
    return (
      <Tooltip
        title={name}
        placement={'bottomLeft'}
        overlayStyle={{ maxWidth: 260 }}
        visible={showFullName}
      >
        <SpeakerName ref={nameRef} style={{ cursor: 'default' }}>
          {name}
        </SpeakerName>
      </Tooltip>
    );
  }, [isExpandItem, name, showFullName]);

  const renderSpeakerSummaryPreviewMode = useMemo(() => {
    return (
      <Content
        className={isExpandItem ? props.contentClassRef.current : ''}
        expanded={expanded}
      >
        {content}
      </Content>
    );
  }, [content, expanded, isExpandItem, props.contentClassRef]);

  return (
    <Wrapper>
      <Heading>
        <AvatarContainer
          onMouseEnter={isExpandItem ? undefined : onMouseEnter}
          onMouseLeave={isExpandItem ? undefined : onMouseLeave}
        >
          {renderSpeakerAvatar}
        </AvatarContainer>
        {renderReviewSpokesPersonMode}
      </Heading>
      <ContentContainer ref={contentRef as any}>
        {renderSpeakerSummaryPreviewMode}
      </ContentContainer>
    </Wrapper>
  );
};

const MemoWrapper = React.memo(SpeakerSummaryItem);

export { MemoWrapper as SpeakerSummaryItem };
