export interface LabCardsValues {
  id: number;
  value: string;
  time?: number;
  endTime?: number;
  extensions?: Extension[];
  native?: boolean;
  labShowKeys?: Array<
    // 场景特有
    | 'keyWordsExtractor' // 关键词
    | 'fullSummary' // 全文概要
    | 'titleGenerator' // 章节速览
    | 'agendaSummary' // 章节速览摘要
    | 'roleSummary' // 发言总结摘要
    | 'pptExtractor' // PPT提取
    | 'pptSummary' // PPT摘要
    | 'qaReview' // 问答回顾
    | 'qaKeyPoint' // 要点回顾
    | 'actionExtractor' // 待办事项
    | 'qaReview' // 问答回顾
    | 'qaKeyPoint' // 要点回顾
  >;
  title: string; // 问答回顾特有
  summary?: string; // 议程摘要
}

export interface ISpeaker {
  isNewSpeakerSummer: any;
  ui: string;
  name: string;
  avatarUrl?: string;
  isSystem?: boolean;
  userid?: string;
  nameAvaId?: number;
}

// 说话人信息数据
export interface ISpeakerIdentify {
  system_user_info?: Record<string, { name: string; avatarUrl: string }>;
  user_info: Record<string, ISpeaker>;
  user_map_info: Record<string, string>;
}

/**
 * status=0，已完成
 * status=1，加载中。
 * status=2 是摘要提取失败
 * status = 4，没有ppt
 * status = 5，摘要处理中
 * status = 7，摘要处理失败
 * status = 8，是摘要提取失败
 */
export enum PPTStatusType {
  'success' = 0,
  'loading' = 1,
  'pptFail' = 2,
  'pptNull' = 4,
  'pptLoading' = 5,
  'pptSFail' = 7,
}

// token数据类型
export interface ITransToken {
  id: number;
  bt: number;
  et: number;
  tc: string;
  si: number;
}

// 转写结果段落数据类型
export interface ITransParagraph {
  pi: string; // parapgrph_id，段落唯一标识，19位，13位录音创建时间戳 + 6位数字
  ui: string; // user_id，用户ID，0代表未检查到的用户
  sc: ITransToken[];
}

export interface LabCards {
  key: string;
  status: 0 | 1 | 2 | 3; // 0 有结果 1 计算中 2 失败 3 文档太短
  basicInfo: {
    name: string;
    des: string;
    icon: string;
    visible: 0 | 1; // 0可点击展开， 1 仅展开。
    tracked?: 0 | 1; // 0不展示回溯 ，1 可回溯
  };
  feedbackInfo: {
    des: string;
    radios: Array<{ id: number; text: string }>;
    feedbackId?: number;
    choice?: number;
  };
  feedbackDetailList?: Array<{
    bindId: number; // 反馈对应的摘要id
    feedbackChoice: number; // 用户选择的星级
    feedbackInfo: string; // 反馈的文字信息
    id: number;
    labShowKey: string; // 反馈实验名称
    transId: string;
    userId: number;
  }>;
  contents?: Array<{
    type: 'list' | 'tag';
    contentValues: LabCardsValues[];
  }>;
}

export interface Extension {
  startTime: number;
  endTime: number;
  sId: number;
  sentenceIdsOfAnswer?: number[];
  sentenceIdsOfQuestion?: number[];
  sentenceInfoOfAnswer?: SentenceInfo[];
  sentenceInfoOfQuestion?: SentenceInfo[];
}

export interface SentenceInfo {
  beginTime: number;
  endTime: number;
  paragraphId: string;
  sentenceId: number;
  ui: string;
}

// PPT
export interface PPTInfoType {
  pictureThumbnailOssLink: any;
  id: string;
  pictureKey: string;
  pictureThumbnailKey: string;
  pptSummary: string[] | string;
  status: 0 | 1 | 2 | 3; // 0完成，3字数太少，1加载中，2失败
  time: number;
}
