import {
  docBigModelHooks,
  docTranslateHooks,
} from '../../../../../../../documentModel';
import { iTodo } from '../../../../../../../documentModel/docBigModel';
import { useEffect, useState } from 'react';

/**
 * 发言人信息获取
 */
const useInitToDoList = () => {
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();

  const { todoList } = currentDocBigModelData || {};

  const { docTranslateData } = docTranslateHooks.useDocTranslateData();
  const { bigModelTranslate, translateIsOpen } = docTranslateData || {};
  const { actionExtractor } = bigModelTranslate || {};

  // const { qnaController } = useDataHooks();
  const [_todoList, setTodoList] = useState<iTodo[] | undefined>();

  useEffect(() => {
    let _List = todoList;
    if (todoList && actionExtractor && actionExtractor.length) {
      _List = todoList.map((item) => {
        const _item = { ...item };
        if (translateIsOpen) {
          _item.value =
            actionExtractor.find((i) => i.id === item.id)?.value || _item.value;
        }
        return _item;
      });
    }
    setTodoList(_List);
  }, [todoList, actionExtractor, translateIsOpen]);

  return { todoList: _todoList };
};

export { useInitToDoList };
